/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.scanner.Scanner;
import java.util.Map;
import java.util.function.Function;

public enum RoleRiskFactor {
    LOW("\tPermissions that have minimal impact on the security and functionality of the web service.\n\tThese permissions typically involve read-only access to non-sensitive data or basic actions\n\tthat do not pose a significant risk if misused.\n"),
    MEDIUM("\tPermissions that have moderate impact on the security and functionality of the web service.\n\tThese permissions may involve write access to certain data or actions that can affect the system's behavior or\n\tconfiguration.\n\tCare should be taken when granting these permissions.\n"),
    HIGH("\tPermissions that have a high impact on the security and functionality of the web service.\n\tThese permissions involve access to sensitive data, critical system functions, or actions that can modify\n\timportant configurations.\n\tOnly trusted and authorized individuals should have these permissions.\n"),
    CRITICAL("\tPermissions that have a critical impact on the security and functionality of the web service.\n\tThese permissions involve access to highly sensitive data, privileged system functions,\n\tor actions that can cause severe damage to the system or compromise its security.\n\tThese permissions should be granted only to a limited number of trusted administrators.\n"),
    MAXIMUM("\tPermissions that have the maximum impact on the security and functionality of the web service.\n\tThese permissions involve access to the most critical and sensitive areas of the system,\n\tsuch as administrative functions, server configurations, or financial data.\n\tOnly a small group of authorized individuals with the highest level of trust should have these permissions,\n\tand they should be closely monitored and audited.\n");

    public final String description;
    public static final Map<RoleRiskFactor, String> DESCRIPTIONS_BY_RISK_FACTOR;

    static {
        DESCRIPTIONS_BY_RISK_FACTOR = Scanner.of((Object[])RoleRiskFactor.values()).toMap(Function.identity(), roleRiskFactor -> roleRiskFactor.description);
    }

    private RoleRiskFactor(String description) {
        this.description = description;
    }
}

