/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.role.RoleRiskFactor;
import io.datarouter.enums.StringMappedEnum;
import java.util.Set;

public enum DatarouterUserRole implements RoleEnum<DatarouterUserRole>
{
    ADMIN("admin", "Legacy admin role. You probably want datarouterAdmin", RoleRiskFactor.HIGH),
    DATAROUTER_ACCOUNTS("datarouterAccounts", "Permission to view and edit accounts", RoleRiskFactor.HIGH),
    DATAROUTER_ADMIN("datarouterAdmin", "The highest level of permission in Datarouter, which includes at minimum all other base Datarouter role permissions", RoleRiskFactor.CRITICAL),
    DATAROUTER_JOB("datarouterJob", "Permission to view and manage jobs & conveyors", RoleRiskFactor.HIGH),
    DATAROUTER_MONITORING("datarouterMonitoring", "Permission to view monitoring pages (e.g. stack traces, server status, etc). Can also set monitoring thresholds.", RoleRiskFactor.MEDIUM),
    DATAROUTER_SETTINGS("datarouterSettings", "Permission to view & edit cluster settings.", RoleRiskFactor.HIGH),
    DATAROUTER_TOOLS("datarouterTools", "Permission to use miscellaneous admin tools.", RoleRiskFactor.HIGH),
    DOC_USER("docUser", "Permission to view API and other service documentation pages.", RoleRiskFactor.LOW),
    REQUESTOR("requestor", "Most basic permission. Only grants the ability to request other roles.", RoleRiskFactor.LOW),
    USER("user", "General role one step up from requestor. Provides various low-risk permissions.", RoleRiskFactor.LOW);

    public static final StringMappedEnum<DatarouterUserRole> BY_PERSISTENT_STRING;
    private final Role role;

    static {
        BY_PERSISTENT_STRING = new StringMappedEnum((Object[])DatarouterUserRole.values(), value -> value.role.persistentString);
    }

    private DatarouterUserRole(String persistentString, String description, RoleRiskFactor riskFactor) {
        this.role = new Role(persistentString, description, riskFactor);
    }

    @Override
    public String getPersistentString() {
        return this.role.getPersistentString();
    }

    @Override
    public DatarouterUserRole fromPersistentString(String str) {
        return (DatarouterUserRole)BY_PERSISTENT_STRING.fromOrNull((Object)str);
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public static Set<Role> getDatarouterPrivilegedRoles() {
        return Set.of(ADMIN.getRole(), DATAROUTER_ACCOUNTS.getRole(), DATAROUTER_ADMIN.getRole(), DATAROUTER_JOB.getRole(), DATAROUTER_MONITORING.getRole(), DATAROUTER_SETTINGS.getRole(), DATAROUTER_TOOLS.getRole());
    }
}

