/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.model.dto;

import io.datarouter.auth.model.dto.RoleApprovalRequirementStatus;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleApprovalType;
import io.datarouter.scanner.Scanner;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record UserRoleMetadata(Role role, boolean hasRole, Map<RoleApprovalType, RoleApprovalRequirementStatus> requirementStatusByApprovalType, Optional<RoleApprovalType> editorPrioritizedApprovalType, Optional<Boolean> editorCanRevoke, List<String> groupsHasWithRole) {
    public Optional<String> getChangeString(UserRoleMetadata oldRoleMetaData) {
        if (!Objects.equals(this.role, oldRoleMetaData.role)) {
            return Optional.empty();
        }
        if (this.hasRole && !oldRoleMetaData.hasRole) {
            return Optional.of(String.valueOf(this.role) + ": granted (prior approvals=" + oldRoleMetaData.requirementStatusByApprovalType.toString() + ")");
        }
        if (!this.hasRole && oldRoleMetaData.hasRole()) {
            return Optional.of(String.valueOf(this.role) + ": revoked");
        }
        return Optional.of("%1$s: approval change %2$s => %3$s".formatted(this.role, oldRoleMetaData.requirementStatusByApprovalType.toString(), this.requirementStatusByApprovalType.toString()));
    }

    public UserRoleMetadataJsDto toJsDto() {
        return new UserRoleMetadataJsDto(this.role.persistentString, this.role.description, this.role.riskFactor.name(), this.role.riskFactor.description, this.hasRole, Scanner.of(this.requirementStatusByApprovalType.keySet()).toMap(RoleApprovalType::persistentString, this.requirementStatusByApprovalType::get), this.editorPrioritizedApprovalType.map(RoleApprovalType::persistentString).orElse(null), this.editorCanRevoke.orElse(null), this.groupsHasWithRole);
    }

    public record UserRoleMetadataJsDto(String roleName, String roleDescription, String roleRiskFactor, String roleRiskFactorDescription, boolean hasRole, Map<String, RoleApprovalRequirementStatus> requirementStatusByApprovalType, String editorPrioritizedApprovalType, Boolean editorCanRevoke, List<String> groupsHasWithRole) {
    }
}

