/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.config;

import io.datarouter.auth.authenticate.authenticator.DatarouterAuthenticator;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.session.Session;
import io.datarouter.util.Require;
import io.datarouter.util.time.DurationTool;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public interface DatarouterAuthenticationConfig {
    public static final DatarouterAuthPaths PATHS = new DatarouterAuthPaths();

    public String getKeepAlivePath();

    public String getShutdownPath();

    default public String getSigninPath() {
        return DatarouterAuthenticationConfig.PATHS.signin.toSlashedString();
    }

    default public String getSigninSubmitPath() {
        return DatarouterAuthenticationConfig.PATHS.signin.submit.toSlashedString();
    }

    default public String getPermissionRequestPath() {
        return DatarouterAuthenticationConfig.PATHS.permissionRequest.toSlashedString();
    }

    public String getUsernameParam();

    public String getPasswordParam();

    public String getUserRolesParam();

    public String getEnabledParam();

    public String getSignatureParam();

    public String getNonceParam();

    public String getTimestampParam();

    public String getCookiePrefix();

    public String getUserTokenCookieName();

    public String getSessionTokenCookieName();

    public String getTargetUrlName();

    public Duration getUserTokenTimeoutDuration();

    public Duration getSessionTokenTimeoutDuration();

    default public boolean useSameSiteNone() {
        return false;
    }

    default public boolean isSessionExpired(Session session) {
        Require.noNulls((Object[])new Object[]{session, session.getUpdated()});
        return this.getSessionTokenTimeoutDuration().minus(DurationTool.sinceDate((Date)session.getUpdated())).isNegative();
    }

    public List<DatarouterAuthenticator> getAuthenticators(HttpServletRequest var1);

    public boolean useDatarouterAuthentication();
}

