/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user.datarouteruser;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleManager;
import io.datarouter.auth.session.SessionBasedUser;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUserKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.codec.FieldCodec;
import io.datarouter.model.field.codec.MilliTimeFieldCodec;
import io.datarouter.model.field.codec.StringListToBinaryCsvFieldCodec;
import io.datarouter.model.field.codec.StringListToCsvFieldCodec;
import io.datarouter.model.field.imp.DateField;
import io.datarouter.model.field.imp.DateFieldKey;
import io.datarouter.model.field.imp.StringEncodedField;
import io.datarouter.model.field.imp.StringEncodedFieldKey;
import io.datarouter.model.field.imp.StringField;
import io.datarouter.model.field.imp.StringFieldKey;
import io.datarouter.model.field.imp.array.ByteArrayEncodedField;
import io.datarouter.model.field.imp.array.ByteArrayEncodedFieldKey;
import io.datarouter.model.field.imp.comparable.BooleanField;
import io.datarouter.model.field.imp.comparable.BooleanFieldKey;
import io.datarouter.model.field.imp.comparable.LongEncodedField;
import io.datarouter.model.field.imp.comparable.LongEncodedFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.base.BaseStringUniqueKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.scanner.Scanner;
import io.datarouter.types.MilliTime;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Supplier;

public class DatarouterUser
extends BaseDatabean<DatarouterUserKey, DatarouterUser>
implements SessionBasedUser {
    private String username;
    private String userToken;
    private String passwordSalt;
    private String passwordDigest;
    private Boolean enabled;
    private List<String> roles;
    private List<String> samlGroups;
    private Date created;
    private MilliTime createdMs;
    private Date lastLoggedIn;
    private MilliTime lastLoggedInMs;
    private String zoneId;

    public DatarouterUser() {
        super((PrimaryKey)new DatarouterUserKey());
    }

    public DatarouterUser(Long id) {
        super((PrimaryKey)new DatarouterUserKey(id));
    }

    public DatarouterUser(Long id, String username) {
        this(id);
        this.username = username;
    }

    public Supplier<DatarouterUserKey> getKeySupplier() {
        return DatarouterUserKey::new;
    }

    public Collection<Role> getRolesIgnoreSaml() {
        return Scanner.of((Iterable)Optional.ofNullable(this.roles).orElseGet(List::of)).map(Role::new).list();
    }

    public Set<Role> getRolesWithSamlGroups(RoleManager roleManager) {
        return roleManager.calculateRolesWithGroups(this.getRolesIgnoreSaml(), this.getSamlGroups());
    }

    public void setRoles(Collection<Role> roles) {
        this.roles = Scanner.of(roles).map(Role::getPersistentString).sort().distinct().list();
    }

    public DatarouterUser addRoles(Collection<Role> roles) {
        this.setRoles(Scanner.concat((Iterable[])new Iterable[]{this.getRolesIgnoreSaml(), roles}).collect(HashSet::new));
        return this;
    }

    public DatarouterUser removeRoles(Collection<Role> roles) {
        HashSet<Role> newRoles = new HashSet<Role>(this.getRolesIgnoreSaml());
        newRoles.removeAll(roles);
        this.setRoles(newRoles);
        return this;
    }

    public List<String> getSamlGroups() {
        return Optional.ofNullable(this.samlGroups).orElseGet(List::of);
    }

    public void setSamlGroups(List<String> samlGroups) {
        this.samlGroups = samlGroups;
    }

    public static boolean equals(DatarouterUser first, DatarouterUser second) {
        return first.equals(second) && Objects.equals(first.getUsername(), second.getUsername()) && Objects.equals(first.getUserToken(), second.getUserToken()) && Objects.equals(first.getPasswordSalt(), second.getPasswordSalt()) && Objects.equals(first.getPasswordDigest(), second.getPasswordDigest()) && Objects.equals(first.getEnabled(), second.getEnabled()) && Objects.equals(first.getRolesIgnoreSaml(), second.getRolesIgnoreSaml()) && Objects.equals(first.getCreated(), second.getCreated()) && Objects.equals(first.getLastLoggedIn(), second.getLastLoggedIn()) && Objects.equals(first.getZoneId(), second.getZoneId());
    }

    @Deprecated
    public Date getCreated() {
        return this.created;
    }

    public Instant getCreatedInstant() {
        return this.created.toInstant();
    }

    public void setCreated(Date created) {
        this.created = created;
        this.createdMs = MilliTime.of((Date)created);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPasswordDigest() {
        return this.passwordDigest;
    }

    public void setPasswordDigest(String passwordDigest) {
        this.passwordDigest = passwordDigest;
    }

    @Override
    public Long getId() {
        return ((DatarouterUserKey)this.getKey()).getId();
    }

    public String getPasswordSalt() {
        return this.passwordSalt;
    }

    public void setPasswordSalt(String passwordSalt) {
        this.passwordSalt = passwordSalt;
    }

    public String getUserToken() {
        return this.userToken;
    }

    @Override
    public String getToken() {
        return this.getUserToken();
    }

    public void setUserToken(String userToken) {
        this.userToken = userToken;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public Boolean isEnabled() {
        return this.getEnabled();
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Instant getLastLoggedIn() {
        return Optional.ofNullable(this.lastLoggedIn).map(Date::toInstant).orElse(null);
    }

    public void setLastLoggedIn(Instant lastLoggedIn) {
        if (lastLoggedIn == null) {
            this.lastLoggedIn = null;
            this.lastLoggedInMs = null;
        } else {
            this.lastLoggedIn = Date.from(lastLoggedIn);
            this.lastLoggedInMs = MilliTime.of((Instant)lastLoggedIn);
        }
    }

    @Override
    public Optional<ZoneId> getZoneId() {
        return Optional.ofNullable(this.zoneId).map(ZoneId::of);
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId.getId();
    }

    public static class DatarouterUserByUserTokenLookup
    extends BaseStringUniqueKey<DatarouterUserKey> {
        public DatarouterUserByUserTokenLookup(String userToken) {
            super(userToken);
        }

        public List<Field<?>> getFields() {
            return List.of(new StringField(FieldKeys.userToken, this.id));
        }
    }

    public static class DatarouterUserByUsernameLookup
    extends BaseStringUniqueKey<DatarouterUserKey> {
        public DatarouterUserByUsernameLookup(String username) {
            super(username);
        }

        public List<Field<?>> getFields() {
            return List.of(new StringField(FieldKeys.username, this.id));
        }
    }

    public static class DatarouterUserFielder
    extends BaseDatabeanFielder<DatarouterUserKey, DatarouterUser> {
        public DatarouterUserFielder() {
            super(DatarouterUserKey::new);
        }

        public List<Field<?>> getNonKeyFields(DatarouterUser user) {
            return List.of(new StringField(FieldKeys.username, user.username), new StringField(FieldKeys.userToken, user.userToken), new StringField(FieldKeys.passwordSalt, user.passwordSalt), new StringField(FieldKeys.passwordDigest, user.passwordDigest), new BooleanField(FieldKeys.enabled, user.enabled), new ByteArrayEncodedField(FieldKeys.roles, user.roles), new StringEncodedField(FieldKeys.samlGroups, user.samlGroups), new DateField(FieldKeys.created, user.created), new LongEncodedField(FieldKeys.createdMs, (Object)user.createdMs), new DateField(FieldKeys.lastLoggedIn, user.lastLoggedIn), new LongEncodedField(FieldKeys.lastLoggedInMs, (Object)user.lastLoggedInMs), new StringField(FieldKeys.zoneId, user.zoneId));
        }

        public Map<String, List<Field<?>>> getUniqueIndexes(DatarouterUser databean) {
            TreeMap indexesByName = new TreeMap();
            indexesByName.put("unique_username", new DatarouterUserByUsernameLookup(null).getFields());
            indexesByName.put("unique_userToken", new DatarouterUserByUserTokenLookup(null).getFields());
            return indexesByName;
        }
    }

    public static class FieldKeys {
        public static final StringFieldKey username = new StringFieldKey("username");
        public static final StringFieldKey userToken = new StringFieldKey("userToken");
        public static final StringFieldKey passwordSalt = new StringFieldKey("passwordSalt");
        public static final StringFieldKey passwordDigest = new StringFieldKey("passwordDigest").withSize(65535);
        public static final BooleanFieldKey enabled = new BooleanFieldKey("enabled");
        public static final ByteArrayEncodedFieldKey<List<String>> roles = new ByteArrayEncodedFieldKey("roles", StringListToBinaryCsvFieldCodec.INSTANCE).withSize(0xFFFFFF);
        public static final StringEncodedFieldKey<List<String>> samlGroups = new StringEncodedFieldKey("samlGroups", StringListToCsvFieldCodec.INSTANCE).withSize(0xFFFFFF);
        public static final DateFieldKey created = new DateFieldKey("created");
        public static final LongEncodedFieldKey<MilliTime> createdMs = new LongEncodedFieldKey("createdMs", (FieldCodec)new MilliTimeFieldCodec());
        public static final DateFieldKey lastLoggedIn = new DateFieldKey("lastLoggedIn");
        public static final LongEncodedFieldKey<MilliTime> lastLoggedInMs = new LongEncodedFieldKey("lastLoggedInMs", (FieldCodec)new MilliTimeFieldCodec());
        public static final StringFieldKey zoneId = new StringFieldKey("zoneId");
    }
}

