/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account.permission;

import io.datarouter.auth.storage.account.permission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.account.permission.DatarouterAccountPermission;
import io.datarouter.auth.storage.account.permission.DatarouterAccountPermissionKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.virtualnode.redundant.RedundantIndexedSortedMapStorageNode;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@Singleton
public class DatarouterAccountPermissionDao
extends BaseDao
implements BaseDatarouterAccountPermissionDao {
    private final SortedMapStorage.SortedMapStorageNode<DatarouterAccountPermissionKey, DatarouterAccountPermission, DatarouterAccountPermission.DatarouterAccountPermissionFielder> node;

    @Inject
    public DatarouterAccountPermissionDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterAccountPermissionDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            NodeBuilder builder = nodeFactory.create(clientId, DatarouterAccountPermission::new, DatarouterAccountPermission.DatarouterAccountPermissionFielder::new).withTag(Tag.DATAROUTER).withTableName(datarouterAccountPermissionDaoParams.tableName);
            IndexedSortedMapStorage.IndexedSortedMapStorageNode node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)builder.build();
            return node;
        }).listTo(RedundantIndexedSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    @Override
    public void put(DatarouterAccountPermission databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(List<DatarouterAccountPermission> databeans) {
        this.node.putMulti(databeans);
    }

    @Override
    public void deleteWithPrefix(DatarouterAccountPermissionKey prefix) {
        this.node.deleteWithPrefix((PrimaryKey)prefix);
    }

    @Override
    public void delete(DatarouterAccountPermissionKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public void deleteMulti(List<DatarouterAccountPermissionKey> keys) {
        this.node.deleteMulti(keys);
    }

    @Override
    public Scanner<DatarouterAccountPermissionKey> scanKeys() {
        return this.node.scanKeys();
    }

    @Override
    public Scanner<DatarouterAccountPermissionKey> scanKeysWithPrefixes(Collection<DatarouterAccountPermissionKey> prefixes) {
        return this.node.scanKeysWithPrefixes(prefixes);
    }

    public static class DatarouterAccountPermissionDaoParams
    extends BaseRedundantDaoParams {
        public final Optional<String> tableName;

        public DatarouterAccountPermissionDaoParams(List<ClientId> clientIds) {
            super(clientIds);
            this.tableName = Optional.empty();
        }

        public DatarouterAccountPermissionDaoParams(List<ClientId> clientIds, String tableName) {
            super(clientIds);
            Require.isTrue((boolean)StringTool.notNullNorEmpty((String)tableName));
            this.tableName = Optional.of(tableName);
        }
    }
}

