/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.session;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.session.Session;
import io.datarouter.util.string.StringTool;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletRequest;

public interface CurrentSessionInfo {
    default public Optional<String> findNonEmptyUsername(ServletRequest request) {
        return this.getSession(request).map(Session::getUsername).filter(StringTool::notEmpty);
    }

    default public String getNonEmptyUsernameOrElse(ServletRequest request, String other) {
        return this.findNonEmptyUsername(request).orElse(other);
    }

    public Optional<? extends Session> getSession(ServletRequest var1);

    default public Session getRequiredSession(ServletRequest request) {
        return this.getSession(request).get();
    }

    public Set<Role> getRoles(ServletRequest var1);

    default public boolean hasRole(ServletRequest request, Role role) {
        return this.getRoles(request).contains(role);
    }

    default public boolean hasRole(ServletRequest request, RoleEnum<?> role) {
        return this.hasRole(request, role.getRole());
    }

    default public boolean hasAnyRole(ServletRequest request, Collection<Role> targetRoles) {
        Set<Role> roles = this.getRoles(request);
        return targetRoles.stream().anyMatch(roles::contains);
    }

    default public boolean hasAnyRoleEnum(ServletRequest request, Collection<RoleEnum<?>> targetRoles) {
        Set<Role> roles = this.getRoles(request);
        return targetRoles.stream().map(RoleEnum::getRole).anyMatch(roles::contains);
    }

    public static class NoOpCurrentSessionInfo
    implements CurrentSessionInfo {
        @Override
        public Optional<? extends Session> getSession(ServletRequest request) {
            return Optional.empty();
        }

        @Override
        public Set<Role> getRoles(ServletRequest request) {
            return Collections.emptySet();
        }
    }
}

