/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.auth.role.DatarouterRoleApprovalType;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleApprovalType;
import io.datarouter.auth.role.RoleApprovalTypeEnum;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.scanner.OptionalScanner;
import io.datarouter.scanner.Scanner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public interface RoleManager {
    public RoleEnum<? extends RoleEnum<?>> getRoleEnum();

    default public Optional<Role> findRoleFromPersistentString(String persistentString) {
        return Optional.ofNullable(this.getRoleEnum().fromPersistentString(persistentString)).map(RoleEnum::getRole);
    }

    public RoleApprovalTypeEnum<? extends RoleApprovalTypeEnum<?>> getRoleApprovalTypeEnum();

    default public Optional<RoleApprovalType> findRoleApprovalTypeFromPersistentString(String persistentString) {
        return Optional.ofNullable(this.getRoleApprovalTypeEnum().fromPersistentString(persistentString)).map(RoleApprovalTypeEnum::getRoleApprovalType);
    }

    public Set<Role> getAllRoles();

    public Set<Role> getRolesForGroup(String var1);

    public Set<Role> getSuperAdminRoles();

    public Set<Role> getDefaultRoles();

    default public Map<RoleApprovalType, Integer> getRoleApprovalRequirements(Role role) {
        return Map.of(DatarouterRoleApprovalType.ADMIN.getRoleApprovalType(), 1);
    }

    default public Map<Role, Map<RoleApprovalType, Integer>> getAllRoleApprovalRequirements() {
        return Scanner.of(this.getAllRoles()).toMap(Function.identity(), role -> {
            Map<RoleApprovalType, Integer> roleApprovalRequirements = this.getRoleApprovalRequirements((Role)role);
            if (roleApprovalRequirements == null || roleApprovalRequirements.isEmpty()) {
                return Map.of(DatarouterRoleApprovalType.ADMIN.getRoleApprovalType(), 1);
            }
            return roleApprovalRequirements;
        });
    }

    public Map<RoleApprovalType, BiFunction<DatarouterUser, DatarouterUser, Boolean>> getApprovalTypeAuthorityValidators();

    default public List<RoleApprovalType> getPrioritizedRoleApprovalTypes(DatarouterUser editor, DatarouterUser user, Set<RoleApprovalType> relevantApprovalTypes) {
        Map<RoleApprovalType, BiFunction<DatarouterUser, DatarouterUser, Boolean>> approvalTypeAuthorityValidators = this.getApprovalTypeAuthorityValidators();
        return Scanner.of(relevantApprovalTypes).include(approvalTypeAuthorityValidators::containsKey).include(roleApprovalType -> {
            BiFunction validatorFunction = (BiFunction)approvalTypeAuthorityValidators.get(roleApprovalType);
            return (Boolean)validatorFunction.apply(editor, user);
        }).map(RoleApprovalType::persistentString).map(this::findRoleApprovalTypeFromPersistentString).concat(OptionalScanner::of).sort((Comparator)new RoleApprovalType.RoleApprovalTypePriorityComparator()).list();
    }

    default public Set<Role> getUnimportantRoles() {
        return Set.of();
    }

    default public Set<String> getAdditionalPermissionRequestEmailRecipients(DatarouterUser requestor, Set<Role> requestedRoles) {
        return Set.of();
    }

    default public Set<Role> calculateRolesWithGroups(Collection<Role> roles, Collection<String> groups) {
        return (Set)Scanner.of(groups).concatIter(this::getRolesForGroup).append(roles).collect(HashSet::new);
    }

    default public Map<Role, List<String>> getGroupsByRole(Collection<String> groups) {
        HashMap<Role, List<String>> groupsByRoles = new HashMap<Role, List<String>>();
        for (String group : groups) {
            Set<Role> rolesForGroup = this.getRolesForGroup(group);
            for (Role role : rolesForGroup) {
                groupsByRoles.putIfAbsent(role, new ArrayList());
                ((List)groupsByRoles.get(role)).add(group);
            }
        }
        return groupsByRoles;
    }
}

