/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.enums.StringMappedEnum;
import java.util.Set;

public enum DatarouterUserRole implements RoleEnum<DatarouterUserRole>
{
    ADMIN("admin", "Legacy admin role. You probably want datarouterAdmin"),
    DATAROUTER_ACCOUNTS("datarouterAccounts", "Permission to view and edit accounts"),
    DATAROUTER_ADMIN("datarouterAdmin", "The highest level of permission in Datarouter, which includes at minimum all other base Datarouter role permissions"),
    DATAROUTER_JOB("datarouterJob", "Permission to view and manage jobs & conveyors"),
    DATAROUTER_MONITORING("datarouterMonitoring", "Permission to view monitoring pages (e.g. stack traces, server status, etc). Can also set monitoring thresholds."),
    DATAROUTER_SETTINGS("datarouterSettings", "Permission to view & edit cluster settings."),
    DATAROUTER_TOOLS("datarouterTools", "Permission to use miscellaneous admin tools."),
    DOC_USER("docUser", "Permission to view API and other service documentation pages."),
    REQUESTOR("requestor", "Most basic permission. Only grants the ability to request other roles."),
    USER("user", "General role one step up from requestor. Provides various low-risk permissions.");

    public static final StringMappedEnum<DatarouterUserRole> BY_PERSISTENT_STRING;
    private final Role role;

    static {
        BY_PERSISTENT_STRING = new StringMappedEnum((Object[])DatarouterUserRole.values(), value -> value.role.persistentString);
    }

    private DatarouterUserRole(String persistentString, String description) {
        this.role = new Role(persistentString, description);
    }

    @Override
    public String getPersistentString() {
        return this.role.getPersistentString();
    }

    @Override
    public DatarouterUserRole fromPersistentString(String str) {
        return (DatarouterUserRole)BY_PERSISTENT_STRING.fromOrNull((Object)str);
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public static Set<Role> getDatarouterPrivilegedRoles() {
        return Set.of(ADMIN.getRole(), DATAROUTER_ACCOUNTS.getRole(), DATAROUTER_ADMIN.getRole(), DATAROUTER_JOB.getRole(), DATAROUTER_MONITORING.getRole(), DATAROUTER_SETTINGS.getRole(), DATAROUTER_TOOLS.getRole());
    }
}

