/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.auth.role.BaseRoleManager;
import io.datarouter.auth.role.DatarouterRoleApprovalType;
import io.datarouter.auth.role.DatarouterUserRole;
import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleApprovalType;
import io.datarouter.auth.role.RoleApprovalTypeEnum;
import io.datarouter.auth.role.RoleEnum;
import io.datarouter.auth.storage.user.datarouteruser.DatarouterUser;
import io.datarouter.scanner.Scanner;
import jakarta.inject.Singleton;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

@Singleton
public class DatarouterRoleManager
extends BaseRoleManager {
    @Override
    public RoleEnum<? extends RoleEnum<?>> getRoleEnum() {
        return DatarouterUserRole.ADMIN;
    }

    @Override
    public RoleApprovalTypeEnum<? extends RoleApprovalTypeEnum<?>> getRoleApprovalTypeEnum() {
        return DatarouterRoleApprovalType.ADMIN;
    }

    @Override
    public Set<Role> getAllRoles() {
        return (Set)Scanner.of((Object[])DatarouterUserRole.values()).map(RoleEnum::getRole).collect(HashSet::new);
    }

    @Override
    public Map<RoleApprovalType, BiFunction<DatarouterUser, DatarouterUser, Boolean>> getApprovalTypeAuthorityValidators() {
        return Map.of(DatarouterRoleApprovalType.ADMIN.getRoleApprovalType(), (editor, $) -> this.calculateRolesWithGroups(editor.getRolesIgnoreSaml(), editor.getSamlGroups()).contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole()));
    }

    @Override
    public final Set<Role> getSuperAdminRoles() {
        return (Set)Scanner.of((Object[])DatarouterUserRole.values()).map(DatarouterUserRole::getRole).append(this.getAdditionalSuperAdminRoles()).collect(HashSet::new);
    }

    protected Set<Role> getAdditionalSuperAdminRoles() {
        return new HashSet<Role>();
    }

    @Override
    public final Set<Role> getDefaultRoles() {
        return (Set)Scanner.of(this.getAdditionalDefaultRoles()).append((Object[])new Role[]{DatarouterUserRole.REQUESTOR.getRole()}).collect(HashSet::new);
    }

    protected Set<Role> getAdditionalDefaultRoles() {
        return new HashSet<Role>();
    }
}

