/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.role;

import io.datarouter.auth.role.Role;
import io.datarouter.auth.role.RoleManager;
import io.datarouter.util.string.StringTool;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRoleManager
implements RoleManager {
    private static final Logger logger = LoggerFactory.getLogger(BaseRoleManager.class);
    private static final String SUPER_GROUP_ID = "super";
    private static final String DEFAULT_GROUP_ID = "default";
    private Map<String, Set<Role>> roleGroups;

    @Override
    public final Set<Role> getRolesForGroup(String groupId) {
        if (this.roleGroups == null) {
            this.buildRoleGroups();
        }
        return this.roleGroups.getOrDefault(StringTool.nullSafe((String)groupId), Collections.emptySet());
    }

    private void buildRoleGroups() {
        Map<String, Set<Role>> configurableRoleGroups = this.getConfigurableRoleGroups();
        this.checkAndWarnOverride(this.getSuperAdminGroupId(), configurableRoleGroups);
        this.checkAndWarnOverride(this.getDefaultUserGroupId(), configurableRoleGroups);
        if (this.getSuperAdminGroupId().equals(this.getDefaultUserGroupId())) {
            logger.warn("Super and default role group IDs are equal. Using default roles.");
        }
        Map<String, Set> roleGroups = configurableRoleGroups.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Set.copyOf((Collection)entry.getValue())));
        roleGroups.put(this.getSuperAdminGroupId(), Set.copyOf(this.getSuperAdminRoles()));
        roleGroups.put(this.getDefaultUserGroupId(), Set.copyOf(this.getDefaultRoles()));
        this.roleGroups = Collections.unmodifiableMap(roleGroups);
    }

    protected Map<String, Set<Role>> getConfigurableRoleGroups() {
        return Collections.emptyMap();
    }

    protected String getSuperAdminGroupId() {
        return SUPER_GROUP_ID;
    }

    protected String getDefaultUserGroupId() {
        return DEFAULT_GROUP_ID;
    }

    private void checkAndWarnOverride(String key, Map<String, Set<Role>> configurableRoleGroups) {
        Objects.requireNonNull(key, "Super and default role group IDs must be defined.");
        if (configurableRoleGroups.containsKey(key)) {
            logger.warn("ConfigurableRoleGroups uses a reserved role group ID, which will be ignored. Override getSuperUserGroupId or getDefaultUserGroupId to use this role group ID: " + key);
        }
    }
}

