/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.authenticate.saml;

import io.datarouter.auth.authenticate.saml.AuthnRequestMessageConfig;
import io.datarouter.util.Require;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.impl.RandomIdentifierGenerationStrategy;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.encoder.MessageEncodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.messaging.handler.impl.BasicMessageHandlerChain;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SignableSAMLObject;
import org.opensaml.saml.common.binding.security.impl.MessageLifetimeSecurityHandler;
import org.opensaml.saml.common.binding.security.impl.ReceivedEndpointSecurityHandler;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.common.messaging.context.SAMLEndpointContext;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.binding.encoding.impl.HTTPRedirectDeflateEncoder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Scoping;
import org.opensaml.saml.saml2.core.impl.AuthnContextClassRefBuilder;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureValidator;
import org.opensaml.xmlsec.signature.support.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class SamlTool {
    private static final Logger logger = LoggerFactory.getLogger(SamlTool.class);
    private static final RandomIdentifierGenerationStrategy secureRandomIdGenerator = new RandomIdentifierGenerationStrategy();
    public static final String ROLE_GROUP_ATTRIBUTE_NAME = "groupAttributes";
    public static final String ROLE_ATTRIBUTE_NAME = "roleAttributes";
    public static final Duration MESSAGE_LIFETIME = Duration.ofMinutes(1L);

    public static MessageContext buildAuthnRequestAndContext(AuthnRequestMessageConfig config) {
        AuthnRequest authnRequest = (AuthnRequest)SamlTool.build(AuthnRequest.DEFAULT_ELEMENT_NAME);
        authnRequest.setIssueInstant(Instant.now());
        authnRequest.setDestination(config.identityProviderSingleSignOnServiceUrl());
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        authnRequest.setAssertionConsumerServiceURL(config.serviceProviderAssertionConsumerServiceUrl());
        authnRequest.setID(SamlTool.generateSecureRandomId());
        authnRequest.setIssuer(SamlTool.buildIssuer(config.serviceProviderEntityId()));
        authnRequest.setNameIDPolicy(SamlTool.buildNameIdPolicy());
        authnRequest.setRequestedAuthnContext(SamlTool.buildRequestedAuthnContext());
        config.proxyCount().ifPresent(proxyCount -> authnRequest.setScoping(SamlTool.buildScoping(proxyCount)));
        SamlTool.logSamlObject("SamlTool.buildAuthnRequestAndContext", (SAMLObject)authnRequest);
        MessageContext authnRequestContext = new MessageContext();
        authnRequestContext.setMessage((Object)authnRequest);
        ((SAMLBindingContext)authnRequestContext.getSubcontext(SAMLBindingContext.class, true)).setRelayState(config.relayState());
        ((SAMLEndpointContext)((SAMLPeerEntityContext)authnRequestContext.getSubcontext(SAMLPeerEntityContext.class, true)).getSubcontext(SAMLEndpointContext.class, true)).setEndpoint(SamlTool.buildIdpEndpoint(config.identityProviderSingleSignOnServiceUrl()));
        config.signingKeyPair().ifPresent(keyPair -> {
            SignatureSigningParameters params = new SignatureSigningParameters();
            params.setSigningCredential((Credential)new BasicCredential(keyPair.getPublic(), keyPair.getPrivate()));
            params.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            ((SecurityParametersContext)authnRequestContext.getSubcontext(SecurityParametersContext.class, true)).setSignatureSigningParameters(params);
        });
        return authnRequestContext;
    }

    private static Scoping buildScoping(Integer proxyCount) {
        Scoping scoping = (Scoping)SamlTool.build(Scoping.DEFAULT_ELEMENT_NAME);
        scoping.setProxyCount(proxyCount);
        return scoping;
    }

    public static void redirectWithAuthnRequestContext(HttpServletResponse httpServletResponse, MessageContext authnRequestContext) {
        HTTPRedirectDeflateEncoder encoder = new HTTPRedirectDeflateEncoder();
        encoder.setHttpServletResponse(httpServletResponse);
        encoder.setMessageContext(authnRequestContext);
        try {
            encoder.initialize();
            encoder.encode();
        }
        catch (ComponentInitializationException | MessageEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static NameIDPolicy buildNameIdPolicy() {
        NameIDPolicy nameIdPolicy = (NameIDPolicy)SamlTool.build(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        nameIdPolicy.setAllowCreate(Boolean.valueOf(false));
        nameIdPolicy.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        return nameIdPolicy;
    }

    private static RequestedAuthnContext buildRequestedAuthnContext() {
        AuthnContextClassRef passwordAuthnContextClassRef = new AuthnContextClassRefBuilder().buildObject();
        passwordAuthnContextClassRef.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        RequestedAuthnContext requestedAuthnContext = (RequestedAuthnContext)SamlTool.build(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        requestedAuthnContext.setComparison(AuthnContextComparisonTypeEnumeration.MINIMUM);
        requestedAuthnContext.getAuthnContextClassRefs().add(passwordAuthnContextClassRef);
        return requestedAuthnContext;
    }

    private static Endpoint buildIdpEndpoint(String identityProviderSingleSignOnServiceUrl) {
        SingleSignOnService endpoint = (SingleSignOnService)SamlTool.build(SingleSignOnService.DEFAULT_ELEMENT_NAME);
        endpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        endpoint.setLocation(identityProviderSingleSignOnServiceUrl);
        return endpoint;
    }

    public static MessageContext getAndValidateResponseMessageContext(HttpServletRequest request, Credential signatureCredential) {
        MessageContext responseMessageContext = SamlTool.decodeResponse(request);
        SamlTool.logSamlObject("SamlTool.getAndValidateResponseMessageContext", (SAMLObject)responseMessageContext.getMessage());
        SamlTool.validateMessageContext(responseMessageContext, request);
        Response response = (Response)responseMessageContext.getMessage();
        SamlTool.verifySignature((SignableSAMLObject)response, signatureCredential);
        for (Assertion assertion : response.getAssertions()) {
            SamlTool.verifySignature((SignableSAMLObject)assertion, signatureCredential);
        }
        return responseMessageContext;
    }

    private static void validateMessageContext(MessageContext context, HttpServletRequest request) {
        MessageLifetimeSecurityHandler lifetimeSecurityHandler = new MessageLifetimeSecurityHandler();
        lifetimeSecurityHandler.setClockSkew(Duration.ofMillis(1000L));
        lifetimeSecurityHandler.setMessageLifetime(MESSAGE_LIFETIME);
        lifetimeSecurityHandler.setRequiredRule(true);
        ReceivedEndpointSecurityHandler receivedEndpointSecurityHandler = new ReceivedEndpointSecurityHandler();
        receivedEndpointSecurityHandler.setHttpServletRequest(request);
        ArrayList<Object> handlers = new ArrayList<Object>();
        handlers.add(lifetimeSecurityHandler);
        handlers.add(receivedEndpointSecurityHandler);
        BasicMessageHandlerChain handlerChain = new BasicMessageHandlerChain();
        handlerChain.setHandlers(handlers);
        try {
            handlerChain.initialize();
            handlerChain.doInvoke(context);
        }
        catch (ComponentInitializationException | MessageHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            return KeySupport.generateKeyPair((String)"RSA", (int)4096, null);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException("Failed to generate signingKeyPair", e);
        }
    }

    public static void signSamlObject(SignableSAMLObject samlObject, KeyPair signatureKeyPair) {
        BasicCredential credential = CredentialSupport.getSimpleCredential((PublicKey)signatureKeyPair.getPublic(), (PrivateKey)signatureKeyPair.getPrivate());
        Signature signature = (Signature)SamlTool.build(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)credential);
        signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        samlObject.setSignature(signature);
        try {
            XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)samlObject).marshall((XMLObject)samlObject);
            Signer.signObject((Signature)signature);
        }
        catch (MarshallingException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void verifySignature(SignableSAMLObject signedObject, Credential signatureCredential) {
        if (!signedObject.isSigned()) {
            throw new RuntimeException("The SAML object was not signed.");
        }
        Signature signature = signedObject.getSignature();
        try {
            SAMLSignatureProfileValidator profileValidator = new SAMLSignatureProfileValidator();
            profileValidator.validate(signature);
            SignatureValidator.validate((Signature)signature, (Credential)signatureCredential);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static Credential getCredentialFromEncodedRsaPublicKey(String encodedPublicKey) {
        try {
            byte[] keyBytes = Base64.getDecoder().decode(encodedPublicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
            PublicKey key = KeyFactory.getInstance("RSA").generatePublic(keySpec);
            return new BasicCredential(key);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            logger.error("SAML KeyFactory failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Credential getCredentialFromEncodedX509Certificate(String encodedX509Certificate) {
        try {
            byte[] certBytes = Base64.getDecoder().decode(encodedX509Certificate);
            ByteArrayInputStream certByteStream = new ByteArrayInputStream(certBytes);
            X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certByteStream);
            return new BasicX509Credential(cert);
        }
        catch (CertificateException e) {
            logger.error("SAML CertificateFactory failure", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static MessageContext decodeResponse(HttpServletRequest request) {
        HTTPPostDecoder samlMessageDecoder = new HTTPPostDecoder();
        samlMessageDecoder.setHttpServletRequest(request);
        try {
            samlMessageDecoder.initialize();
            samlMessageDecoder.decode();
        }
        catch (ComponentInitializationException | MessageDecodingException e) {
            throw new RuntimeException(e);
        }
        return samlMessageDecoder.getMessageContext();
    }

    public static Issuer buildIssuer(String serviceProviderEntityId) {
        Issuer issuer = (Issuer)SamlTool.build(Issuer.DEFAULT_ELEMENT_NAME);
        issuer.setValue(serviceProviderEntityId);
        return issuer;
    }

    public static Stream<String> streamAttributeValuesByName(String attributeName, Assertion assertion) {
        return assertion.getAttributeStatements().stream().map(AttributeStatement::getAttributes).flatMap(Collection::stream).filter(attribute -> attributeName.equals(attribute.getName())).map(Attribute::getAttributeValues).flatMap(Collection::stream).filter(xmlObject -> xmlObject instanceof XSString).map(xmlObject -> ((XSString)xmlObject).getValue());
    }

    public static String getUrlInRequestContext(HttpServletRequest request, String path) {
        try {
            return new URL(new URL(request.getRequestURL().toString()), String.valueOf(request.getContextPath()) + path).toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to build URL. context: " + request.getRequestURL() + " path " + path);
        }
    }

    public static void logSamlObject(String callsite, SAMLObject object) {
        if (object == null) {
            logger.debug(String.valueOf(callsite) + " - SAMLObject is null");
            return;
        }
        Element element = object.getDOM();
        if (element == null) {
            try {
                Marshaller out = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)object);
                out.marshall((XMLObject)object);
                element = object.getDOM();
            }
            catch (MarshallingException e) {
                logger.error(String.valueOf(callsite) + " - Failed to marshall SAMLObject", (Throwable)e);
                return;
            }
        }
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(element);
            transformer.transform(source, result);
            String xmlString = result.getWriter().toString();
            logger.debug(String.valueOf(callsite) + " - " + xmlString);
        }
        catch (TransformerException e) {
            logger.error(String.valueOf(callsite) + " - Failed to log SAML object.", (Throwable)e);
        }
    }

    public static <T> T build(QName qName) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        return (T)builderFactory.getBuilder(qName).buildObject(qName);
    }

    public static String generateSecureRandomId() {
        return secureRandomIdGenerator.generateIdentifier();
    }

    public static void throwUnlessHttps(HttpServletRequest request) {
        Require.equals((Object)"https", (Object)request.getScheme().toLowerCase(), (String)"https is required for SAML authentication.");
    }
}

