/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web.adminedituser.dto;

import io.datarouter.auth.model.dto.UserRoleMetadata;
import io.datarouter.auth.web.DatarouterPermissionRequestHandler;
import io.datarouter.auth.web.adminedituser.dto.DatarouterUserHistoryDto;
import io.datarouter.auth.web.adminedituser.dto.EditUserDetailDto;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.time.ZoneIds;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class EditUserDetailsDto {
    public final PagePermissionType pagePermissionType;
    public final String editorUsername;
    public final String username;
    public final String id;
    public final String token;
    public final String profileLink;
    public final List<DatarouterPermissionRequestHandler.PermissionRequestDto> requests;
    public final List<DatarouterUserHistoryDto> history;
    public final DeprovisionedUserDto deprovisionedUserDto;
    public final List<UserRoleMetadata.UserRoleMetadataJsDto> userRoleMetadataList;
    public final List<String> availableAccounts;
    public final Map<String, Boolean> currentAccounts;
    public final List<String> availableZoneIds;
    public final String currentZoneId;
    public final String fullName;
    public final Boolean hasProfileImage;
    public final List<EditUserDetailDto> details;
    public final boolean success;
    public final String message;

    public EditUserDetailsDto(PagePermissionType pagePermissionType, String editorUsername, String username, String id, String token, String profileLink, List<DatarouterPermissionRequestHandler.PermissionRequestDto> requests, List<DatarouterUserHistoryDto> history, DeprovisionedUserDto deprovisionedUserDto, List<UserRoleMetadata> userRoleMetadataList, Collection<String> availableAccounts, Collection<String> currentAccounts, boolean success, String message, String currentZoneId, String fullName, boolean hasProfileImage, List<EditUserDetailDto> details) {
        this.pagePermissionType = pagePermissionType;
        this.editorUsername = editorUsername;
        this.username = username;
        this.id = id;
        this.token = token;
        this.profileLink = profileLink;
        this.requests = requests;
        this.history = history;
        this.deprovisionedUserDto = deprovisionedUserDto;
        this.userRoleMetadataList = Scanner.of(userRoleMetadataList).map(UserRoleMetadata::toJsDto).list();
        this.availableAccounts = Scanner.of(availableAccounts).sort(StringTool.COLLATOR_COMPARATOR).deduplicateConsecutive().list();
        HashSet<String> currentAccountsSet = new HashSet<String>(currentAccounts);
        this.currentAccounts = Scanner.of(availableAccounts).toMap(Function.identity(), currentAccountsSet::contains);
        this.success = success;
        this.message = message;
        this.availableZoneIds = Scanner.of((Iterable)ZoneIds.ZONE_IDS).map(ZoneId::getId).sort().list();
        this.currentZoneId = currentZoneId;
        this.fullName = fullName;
        this.hasProfileImage = hasProfileImage;
        this.details = details;
    }

    public EditUserDetailsDto(String errorMessage) {
        this.pagePermissionType = PagePermissionType.NONE;
        this.editorUsername = null;
        this.username = null;
        this.id = null;
        this.token = null;
        this.profileLink = null;
        this.requests = null;
        this.history = null;
        this.deprovisionedUserDto = null;
        this.userRoleMetadataList = null;
        this.availableAccounts = null;
        this.currentAccounts = null;
        this.success = false;
        this.message = errorMessage;
        this.availableZoneIds = null;
        this.currentZoneId = null;
        this.fullName = null;
        this.hasProfileImage = null;
        this.details = null;
    }

    public static enum PagePermissionType {
        ADMIN,
        ROLES_ONLY,
        NONE;

    }
}

