/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web.adminedituser;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.model.dto.UserRoleUpdateDto;
import io.datarouter.auth.model.enums.RoleUpdateType;
import io.datarouter.auth.service.CopyUserListener;
import io.datarouter.auth.service.DatarouterAccountUserService;
import io.datarouter.auth.service.DatarouterUserCreationService;
import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryKey;
import io.datarouter.auth.web.CreateUserFormHtml;
import io.datarouter.auth.web.DatarouterPermissionRequestHandler;
import io.datarouter.auth.web.adminedituser.dto.DatarouterUserHistoryDto;
import io.datarouter.auth.web.adminedituser.dto.DatarouterUserListEntry;
import io.datarouter.auth.web.adminedituser.dto.EditAccountsRequest;
import io.datarouter.auth.web.adminedituser.dto.EditRolesRequest;
import io.datarouter.auth.web.adminedituser.dto.EditUserDetailDto;
import io.datarouter.auth.web.adminedituser.dto.EditUserDetailsDto;
import io.datarouter.auth.web.adminedituser.dto.UpdatePasswordRequest;
import io.datarouter.auth.web.adminedituser.dto.UpdateTimeZoneRequest;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.auth.web.deprovisioning.UserDeprovisioningStatusDto;
import io.datarouter.bytes.EmptyArray;
import io.datarouter.httpclient.endpoint.param.RequestBody;
import io.datarouter.httpclient.response.ApiResponseDto;
import io.datarouter.httpclient.response.ApiResponseErrorDto;
import io.datarouter.pathnode.PathNode;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.js.DatarouterWebJsTool;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.detail.DatarouterUserExternalDetailService;
import io.datarouter.web.user.detail.DatarouterUserExternalDetails;
import io.datarouter.web.user.detail.DatarouterUserProfileLink;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleManager;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.user.session.service.SessionBasedUser;
import io.datarouter.web.util.http.ResponseTool;
import j2html.tags.DomContent;
import jakarta.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminEditUserHandler
extends BaseHandler {
    @Inject
    private DatarouterUserCreationService datarouterUserCreationService;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterUserEditService datarouterUserEditService;
    @Inject
    private DatarouterUserHistoryService datarouterUserHistoryService;
    @Inject
    private DatarouterAccountUserService datarouterAccountUserService;
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterAuthFiles files;
    @Inject
    private DatarouterPermissionRequestDao datarouterPermissionRequestDao;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private Bootstrap4PageFactory pageFactory;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private UserInfo.UserInfoSupplier userInfo;
    @Inject
    private CurrentUserSessionInfoService currentUserSessionInfoService;
    @Inject
    private CopyUserListener copyUserListener;
    @Inject
    private DatarouterUserExternalDetailService detailsService;

    @BaseHandler.Handler
    private Mav viewUsers() {
        return this.getReactMav("Datarouter - Users", Optional.empty());
    }

    @BaseHandler.Handler
    private List<DatarouterUserListEntry> listUsers() {
        Set<Long> userIdsWithPermissionRequests = this.datarouterPermissionRequestDao.getUserIdsWithPermissionRequests();
        return this.datarouterUserDao.scan().map(user -> new DatarouterUserListEntry(user.getId().toString(), user.getUsername(), user.getToken(), userIdsWithPermissionRequests.contains(user.getId()), this.detailsService.getUserProfileLink(user.getUsername()).map(DatarouterUserProfileLink::url).orElse(""))).list();
    }

    @BaseHandler.Handler
    private Mav createUser() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        CreateUserFormHtml template = new CreateUserFormHtml(AdminEditUserHandler.roleToStrings(this.roleManager.getAllRoles()), this.authenticationConfig, this.paths.admin.createUserSubmit.toSlashedStringAfter((PathNode)this.paths.admin, false));
        return this.pageFactory.startBuilder(this.request).withTitle("Datarouter - Create User").withContent((DomContent)template.build()).buildMav();
    }

    @BaseHandler.Handler
    private Mav createUserSubmit() {
        if (this.serverTypeDetector.mightBeProduction()) {
            return this.pageFactory.message(this.request, "This is not supported on production");
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (!this.datarouterUserService.isDatarouterAdmin(currentUser)) {
            this.handleInvalidRequest();
        }
        String username = this.params.required(this.authenticationConfig.getUsernameParam());
        String password = this.params.required(this.authenticationConfig.getPasswordParam());
        Object[] roleStrings = this.params.optionalArray(this.authenticationConfig.getUserRolesParam()).orElse(EmptyArray.STRING);
        Set requestedRoles = (Set)Scanner.of((Object[])roleStrings).map(arg_0 -> ((RoleManager)this.roleManager).findRoleFromPersistentString(arg_0)).map(arg_0 -> AdminEditUserHandler.lambda$3((String[])roleStrings, arg_0)).collect(Collectors.toSet());
        boolean enabled = this.params.optionalBoolean(this.authenticationConfig.getEnabledParam(), Boolean.valueOf(true));
        this.datarouterUserCreationService.createManualUser(currentUser, username, password, requestedRoles, enabled, Optional.empty(), Optional.empty());
        return new InContextRedirectMav(this.request, this.paths.admin.viewUsers);
    }

    @BaseHandler.Handler
    private Mav editUser() {
        DatarouterUser currentUser = this.getCurrentUser();
        DatarouterUser userToEdit = this.params.optional("username").map(DatarouterUser.DatarouterUserByUsernameLookup::new).map(this.datarouterUserDao::getByUsername).or(() -> this.params.optionalLong("userId").map(this.datarouterUserService::getUserById)).orElse(currentUser);
        return this.getReactMav("Datarouter - Edit User " + userToEdit.getUsername(), Optional.of(userToEdit.getUsername()));
    }

    @BaseHandler.Handler
    private EditUserDetailsDto getUserDetails(String username) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)username)) {
            return new EditUserDetailsDto("Invalid username.");
        }
        return this.getEditUserDetailsDto(username);
    }

    @BaseHandler.Handler
    public void getUserProfileImage(String username) {
        this.detailsService.getUserImage(username).map(ByteArrayOutputStream::toByteArray).ifPresent(byteArray -> ResponseTool.writeToOutputStream((HttpServletResponse)this.response, (byte[])byteArray));
    }

    @BaseHandler.Handler
    public ApiResponseDto<EditUserDetailsDto> editRoles(@RequestBody EditRolesRequest request) {
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(request.username()));
        Optional<String> errorMessage = this.datarouterUserEditService.editRoles(this.getCurrentUser(), userToEdit, request.updates(), this.getSigninUrl());
        return new ApiResponseDto((Object)this.getEditUserDetailsDto(userToEdit.getUsername()), true, errorMessage.isPresent() ? new ApiResponseErrorDto(errorMessage.get(), null) : null, 200);
    }

    @BaseHandler.Handler
    public ApiResponseDto<EditUserDetailsDto> editAccounts(@RequestBody EditAccountsRequest request) {
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(request.username()));
        DatarouterUser editor = this.getCurrentUser();
        if (!userToEdit.isEnabled().booleanValue()) {
            return ApiResponseDto.badRequestError((String)"Cannot edit accounts for deprovisioned user %s".formatted(userToEdit.getUsername()));
        }
        if (!this.datarouterUserService.canEditUser(editor, userToEdit)) {
            return ApiResponseDto.forbidden((String)"Current user %1$s cannot edit %2$s".formatted(editor.getUsername(), userToEdit.getUsername()));
        }
        this.datarouterUserEditService.editAccounts(editor, userToEdit, request.updates(), this.getSigninUrl());
        return ApiResponseDto.success((Object)this.getEditUserDetailsDto(userToEdit.getUsername()));
    }

    @BaseHandler.Handler
    public ApiResponseDto<EditUserDetailsDto> updateTimeZone(@RequestBody UpdateTimeZoneRequest request) {
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(request.username()));
        DatarouterUser editor = this.getCurrentUser();
        if (!userToEdit.isEnabled().booleanValue()) {
            return ApiResponseDto.badRequestError((String)"Cannot edit time zone for deprovisioned user %s".formatted(userToEdit.getUsername()));
        }
        if (!this.datarouterUserService.canEditUser(editor, userToEdit)) {
            return ApiResponseDto.forbidden((String)"Current user %1$s cannot edit %2$s".formatted(editor.getUsername(), userToEdit.getUsername()));
        }
        this.datarouterUserEditService.updateTimeZone(editor, userToEdit, request.timeZoneId(), this.getSigninUrl());
        return ApiResponseDto.success((Object)this.getEditUserDetailsDto(userToEdit.getUsername()));
    }

    @BaseHandler.Handler
    private EditUserDetailsDto updatePassword(@RequestBody UpdatePasswordRequest dto) {
        if (dto == null || StringTool.isNullOrEmptyOrWhitespace((String)dto.username()) || StringTool.isNullOrEmptyOrWhitespace((String)dto.newPassword())) {
            return new EditUserDetailsDto("Invalid request.");
        }
        DatarouterUser editor = this.getCurrentUser();
        DatarouterUser userToEdit = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(dto.username()));
        if (!this.checkEditPermission(editor, userToEdit, this.datarouterUserService::canEditUserPassword)) {
            return null;
        }
        if (!this.datarouterUserService.canHavePassword(userToEdit)) {
            return new EditUserDetailsDto("This user is externally authenticated and cannot have a password.");
        }
        this.datarouterUserEditService.changePassword(userToEdit, editor, dto.newPassword(), this.getSigninUrl());
        return this.getEditUserDetailsDto(userToEdit.getUsername());
    }

    @BaseHandler.Handler
    private ApiResponseDto<EditUserDetailsDto> copyUser(String oldUsername, String newUsername) {
        if (StringTool.isNullOrEmptyOrWhitespace((String)oldUsername) || StringTool.isNullOrEmptyOrWhitespace((String)newUsername)) {
            return ApiResponseDto.badRequestError((String)"Invalid request.");
        }
        DatarouterUser editor = this.getCurrentUser();
        DatarouterUser oldUser = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(oldUsername));
        if (editor.getUsername().equals(oldUser.getUsername())) {
            return ApiResponseDto.badRequestError((String)"Cannot copy yourself.");
        }
        if (!this.datarouterUserService.canEditUser(editor, oldUser)) {
            return ApiResponseDto.forbidden((String)"Cannot copy user.");
        }
        Set requestedRoles = oldUser.isEnabled() != false ? new HashSet(oldUser.getRoles()) : this.deprovisionedUserDao.find(new DeprovisionedUserKey(oldUsername)).map(DeprovisionedUser::getRoles).orElseGet(HashSet::new);
        Set requestedAccounts = (Set)Scanner.of(this.datarouterAccountUserService.findAccountNamesForUser((SessionBasedUser)oldUser)).map(DatarouterAccountKey::new).collect(Collectors.toCollection(HashSet::new));
        Optional zoneId = oldUser.getZoneId();
        Optional<String> description = Optional.of("User copied from " + oldUsername + " by " + editor.getUsername());
        DatarouterUser newUser = this.datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(newUsername));
        if (newUser == null) {
            if (this.serverTypeDetector.mightBeProduction()) {
                return ApiResponseDto.forbidden((String)"Cannot copy user's permissions to a non-existent user in production.");
            }
            newUser = this.datarouterUserCreationService.createManualUser(editor, newUsername, null, new HashSet<Role>(Set.of(DatarouterUserRole.REQUESTOR.getRole())), true, zoneId, description);
        } else {
            Scanner.of(this.datarouterAccountUserService.findAccountNamesForUser((SessionBasedUser)newUser)).map(DatarouterAccountKey::new).forEach(requestedAccounts::add);
        }
        String signinUrl = this.getSigninUrl();
        this.datarouterUserEditService.editUser(newUser, editor, true, signinUrl, requestedAccounts, zoneId, description);
        HashSet newUserRoles = new HashSet(newUser.getRoles());
        List requestedRolesUpdates = Scanner.of(requestedRoles).exclude(newUserRoles::contains).map(requestedRole -> new UserRoleUpdateDto(requestedRole.getPersistentString(), RoleUpdateType.APPROVE)).list();
        Optional<String> errorMessage = this.datarouterUserEditService.editRoles(this.getCurrentUser(), newUser, requestedRolesUpdates, this.getSigninUrl());
        this.datarouterUserHistoryService.recordMessage(oldUser, editor, "User copied to " + newUsername + " by " + editor.getUsername());
        this.copyUserListener.onCopiedUser(oldUsername, newUsername);
        return new ApiResponseDto((Object)this.getEditUserDetailsDto(oldUsername), true, errorMessage.isPresent() ? new ApiResponseErrorDto(errorMessage.get(), null) : null, 200);
    }

    private DatarouterUser getCurrentUser() {
        return this.datarouterUserService.getAndValidateCurrentUser(this.getSessionInfo().getRequiredSession());
    }

    private Mav getReactMav(String title, Optional<String> initialUsername) {
        return this.reactPageFactory.startBuilder(this.request).withTitle(title).withReactScript(this.files.js.viewUsersJsx).withJsRawConstant("PATHS", DatarouterWebJsTool.buildRawJsObject(this.buildPaths(this.request.getContextPath()))).withJsStringConstant("INITIAL_USERNAME", initialUsername.orElse("")).buildMav();
    }

    private static List<String> roleToStrings(Collection<Role> roles) {
        return roles.stream().map(Role::getPersistentString).sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList());
    }

    private boolean checkEditPermission(DatarouterUser currentUser, DatarouterUser userToEdit, BiFunction<DatarouterUser, DatarouterUser, Boolean> permissionMethod) {
        Objects.requireNonNull(currentUser);
        Objects.requireNonNull(userToEdit);
        if (!permissionMethod.apply(currentUser, userToEdit).booleanValue()) {
            this.handleInvalidRequest();
            return false;
        }
        return true;
    }

    private String getSigninUrl() {
        String requestUrlWithoutContext = StringTool.getStringBeforeLastOccurrence((String)this.request.getRequestURI(), (String)this.request.getRequestURL().toString());
        return String.valueOf(requestUrlWithoutContext) + this.request.getContextPath() + this.paths.signin.toSlashedString();
    }

    private void handleInvalidRequest() {
        ResponseTool.sendError((HttpServletResponse)this.response, (int)403, (String)"invalid request");
    }

    private EditUserDetailsDto getEditUserDetailsDto(String username) {
        SessionBasedUser user = this.userInfo.get().getUserByUsername(username, false).orElseThrow();
        Set<Role> roles = this.userInfo.get().getRolesByUsername(username, false);
        List permissionRequests = ((Scanner)this.datarouterPermissionRequestDao.scanPermissionRequestsForUser(user.getId()).listTo(requests -> Scanner.of(this.datarouterUserHistoryService.getResolvedRequestToHistoryChangesMap((List<DatarouterPermissionRequest>)requests).entrySet()))).sort(Map.Entry.comparingByKey(DatarouterPermissionRequest.REVERSE_CHRONOLOGICAL_COMPARATOR)).map(this::buildPermissionRequestDto).list();
        List history = Scanner.of(this.datarouterUserHistoryService.getHistoryForUser(user.getId())).map(userHistory -> {
            String currUsername = Optional.ofNullable(userHistory.getEditor()).map(this.datarouterUserService::getUserById).map(DatarouterUser::getUsername).orElse(String.valueOf(userHistory.getEditor()));
            return new DatarouterUserHistoryDto(((DatarouterUserHistoryKey)userHistory.getKey()).getTime().toEpochMilli(), currUsername, userHistory.getChangeType().persistentString, userHistory.getChanges());
        }).reverse().list();
        Optional details = this.detailsService.getUserDetails(username);
        String profileLink = this.detailsService.getUserProfileLink(user.getUsername()).map(DatarouterUserProfileLink::url).orElse("");
        DatarouterUser editor = this.getCurrentUser();
        DatarouterUser datarouterUser = this.datarouterUserService.getUserById(user.getId());
        return new EditUserDetailsDto(this.datarouterUserService.isDatarouterAdmin(editor) ? EditUserDetailsDto.PagePermissionType.ADMIN : EditUserDetailsDto.PagePermissionType.ROLES_ONLY, editor.getUsername(), user.getUsername(), user.getId().toString(), user.getToken(), profileLink, permissionRequests, history, this.deprovisionedUserDao.find(new DeprovisionedUserKey(username)).map(DeprovisionedUser::toDto).orElseGet(() -> AdminEditUserHandler.buildDeprovisionedUserDto(user, roles)), this.datarouterUserService.getRoleMetadataForUser(editor, datarouterUser), this.datarouterAccountUserService.getAllAccountNamesWithUserMappingsEnabled(), this.datarouterAccountUserService.findAccountNamesForUser(user), true, "", user.getZoneId().map(ZoneId::getId).orElse(ZoneId.systemDefault().getId()), details.map(DatarouterUserExternalDetails::fullName).orElse(null), this.detailsService.userImageSupported(), details.map(DatarouterUserExternalDetails::displayDetails).map(Scanner::of).orElseGet(Scanner::empty).map(detail -> new EditUserDetailDto(detail.key(), detail.name(), detail.link().orElse(null))).list());
    }

    private DatarouterPermissionRequestHandler.PermissionRequestDto buildPermissionRequestDto(Map.Entry<DatarouterPermissionRequest, Optional<DatarouterUserHistoryService.HistoryChange>> entry) {
        ZoneId zoneId = this.currentUserSessionInfoService.getZoneId((ServletRequest)this.getRequest());
        DatarouterPermissionRequest request = entry.getKey();
        return new DatarouterPermissionRequestHandler.PermissionRequestDto(((DatarouterPermissionRequestKey)request.getKey()).getRequestTime(), request.getRequestText(), request.getResolutionTime(), entry.getValue().map(DatarouterUserHistoryService.HistoryChange::changes).orElse(null), zoneId, entry.getValue().flatMap(DatarouterUserHistoryService.HistoryChange::editor).map(DatarouterUser::getUsername).orElse(null));
    }

    private static DeprovisionedUserDto buildDeprovisionedUserDto(SessionBasedUser user, Set<Role> roles) {
        UserDeprovisioningStatusDto status = user.isEnabled() != false ? UserDeprovisioningStatusDto.PROVISIONED : UserDeprovisioningStatusDto.NO_RECORD;
        return new DeprovisionedUserDto(user.getUsername(), Scanner.of(roles).map(Role::getPersistentString).list(), status);
    }

    private Map<String, String> buildPaths(String contextPath) {
        HashMap<String, String> allPaths = new HashMap<String, String>(Map.of("editUser", AdminEditUserHandler.getPath(contextPath, this.paths.admin.editUser), "getUserDetails", AdminEditUserHandler.getPath(contextPath, this.paths.admin.getUserDetails), "getUserProfileImage", AdminEditUserHandler.getPath(contextPath, this.paths.admin.getUserProfileImage), "listUsers", AdminEditUserHandler.getPath(contextPath, this.paths.admin.listUsers), "viewUsers", AdminEditUserHandler.getPath(contextPath, this.paths.admin.viewUsers), "updatePassword", AdminEditUserHandler.getPath(contextPath, this.paths.admin.updatePassword), "permissionRequest", AdminEditUserHandler.getPath(contextPath, (PathNode)this.paths.permissionRequest), "declinePermissionRequests", AdminEditUserHandler.getPath(contextPath, this.paths.permissionRequest.declinePermissionRequests), "deprovisionUsers", AdminEditUserHandler.getPath(contextPath, this.paths.userDeprovisioning.deprovisionUsers), "copyUser", AdminEditUserHandler.getPath(contextPath, this.paths.admin.copyUser)));
        allPaths.put("restoreUsers", AdminEditUserHandler.getPath(contextPath, this.paths.userDeprovisioning.restoreUsers));
        allPaths.put("editRoles", AdminEditUserHandler.getPath(contextPath, this.paths.admin.editRoles));
        allPaths.put("editAccounts", AdminEditUserHandler.getPath(contextPath, this.paths.admin.editAccounts));
        allPaths.put("updateTimeZone", AdminEditUserHandler.getPath(contextPath, this.paths.admin.updateTimeZone));
        return allPaths;
    }

    private static String getPath(String contextPath, PathNode pathNode) {
        return String.valueOf(contextPath) + pathNode.toSlashedString();
    }

    private static /* synthetic */ Role lambda$3(String[] stringArray, Optional optionalRole) {
        return (Role)optionalRole.orElseThrow(() -> new IllegalArgumentException("Attempt to create user with unknown role(s): " + Arrays.toString(stringArray)));
    }
}

