/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.DatarouterUserEditService;
import io.datarouter.auth.service.DatarouterUserInfo;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.service.PermissionRequestUserInfo;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.email.html.J2HtmlDatarouterEmailBuilder;
import io.datarouter.email.type.DatarouterEmailTypes;
import io.datarouter.email.type.SimpleEmailType;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.DatarouterSubscribersSupplier;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.storage.config.setting.DatarouterEmailSubscriberSettings;
import io.datarouter.storage.servertype.ServerTypeDetector;
import io.datarouter.util.string.StringTool;
import io.datarouter.util.time.ZonedDateFormatterTool;
import io.datarouter.web.email.DatarouterHtmlEmailService;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.mav.imp.GlobalRedirectMav;
import io.datarouter.web.handler.mav.imp.InContextRedirectMav;
import io.datarouter.web.handler.mav.imp.MessageMav;
import io.datarouter.web.handler.types.Param;
import io.datarouter.web.html.form.HtmlForm;
import io.datarouter.web.html.form.HtmlFormTimezoneSelect;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4FormHtml;
import io.datarouter.web.html.j2html.bootstrap4.Bootstrap4PageFactory;
import io.datarouter.web.user.authenticate.config.DatarouterAuthenticationConfig;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleManager;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.PTag;
import j2html.tags.specialized.TableTag;
import j2html.tags.specialized.TbodyTag;
import j2html.tags.specialized.TdTag;
import j2html.tags.specialized.TrTag;
import jakarta.inject.Inject;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterPermissionRequestHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterPermissionRequestHandler.class);
    private static final String P_REASON = "reason";
    private static final String EMAIL_TITLE = "Permission Request";
    @Inject
    private Bootstrap4PageFactory bootstrap4PageFactory;
    @Inject
    private DatarouterAuthenticationConfig authenticationConfig;
    @Inject
    private DatarouterPermissionRequestDao datarouterPermissionRequestDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private DatarouterHtmlEmailService htmlEmailService;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DatarouterUserEditService userEditService;
    @Inject
    private DatarouterUserInfo datarouterUserInfo;
    @Inject
    private DatarouterEmailTypes.PermissionRequestEmailType permissionRequestEmailType;
    @Inject
    private ServiceName serviceName;
    @Inject
    private ServerTypeDetector serverTypeDetector;
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private DatarouterSubscribersSupplier subscribersEmail;
    @Inject
    private DatarouterEmailSubscriberSettings subscribersSettings;
    @Inject
    private PermissionRequestUserInfo.PermissionRequestUserInfoSupplier userInfoSupplier;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private RoleManager roleManager;

    @BaseHandler.Handler(defaultHandler=true)
    public Mav showForm(Optional<String> deniedUrl, Optional<String> allowedRoles) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        DatarouterUser user = this.getCurrentUser();
        DatarouterPermissionRequest currentRequest = this.datarouterPermissionRequestDao.scanOpenPermissionRequestsForUser(user.getId()).findMax(Comparator.comparing(request -> ((DatarouterPermissionRequestKey)request.getKey()).getRequestTime())).orElse(null);
        Optional<String> defaultSpecifics = deniedUrl.map(url -> "I tried to go to this URL: " + url + "." + allowedRoles.map(" These are its allowed roles at the time of this request: "::concat).orElse(""));
        HashSet<String> emails = new HashSet<String>();
        if (this.serverTypeDetector.mightBeProduction()) {
            emails.addAll(this.permissionRequestEmailType.tos);
        }
        emails.add(this.adminEmail.get());
        if (((Boolean)this.subscribersSettings.includeSubscribers.get()).booleanValue()) {
            emails.addAll(this.subscribersEmail.get());
        }
        String declinePath = this.paths.permissionRequest.declineAll.join("/");
        DivTag existingRequest = new DivTag();
        if (currentRequest != null) {
            existingRequest = TagCreator.div((DomContent[])new DomContent[]{TagCreator.p((String)("You already have an open permission request for " + this.serviceName.get() + ". You may submit another request to replace it.")), TagCreator.p((String)("Time Requested: " + ((DatarouterPermissionRequestKey)currentRequest.getKey()).getRequestTime())), TagCreator.p((String)("Request Text: " + currentRequest.getRequestText())), TagCreator.p((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{"Click ", TagCreator.a((String)"here").withHref(declinePath), " to decline it."})})});
        }
        DivTag introContent = (DivTag)((DivTag)((DivTag)((DivTag)TagCreator.div().with((DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{"Welcome to ", this.serviceName.get(), ". ", TagCreator.a((String)"Sign out.").withHref(String.valueOf(this.request.getContextPath()) + "/" + this.paths.signout.getValue())})}))).with((DomContent)existingRequest)).condWith(currentRequest == null, (DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{"If you need (additional) permissions to use ", this.serviceName.get(), ", submit the form below, and the administrator will follow up."})}))).with((DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.join((Object[])new Object[]{"You will need to ", TagCreator.a((String)"Sign out").withHref(String.valueOf(this.request.getContextPath()) + "/" + this.paths.signout.getValue()), " and sign back in to refresh your permissions"})}));
        String userTimezone = user.getZoneId().map(ZoneId::getId).orElse(null);
        HtmlForm form = new HtmlForm().withAction("?submitAction=submit").withMethod("post");
        form.addTextAreaField().withDisplay(String.format("Why you want to access %s:", this.serviceName.get())).withName(P_REASON).withPlaceholder("explain reason here").required();
        form.addTextField().withDisplay("Additional information we have detected: ").withName("specifics").withValue((String)defaultSpecifics.orElse(null)).readOnly();
        form.addHiddenField("allowedRoles", (String)allowedRoles.orElse(null));
        form.addTimezoneSelectField().withDisplay("Your Timezone").required().withSelected(userTimezone);
        form.addButton().withDisplay("Submit");
        DivTag formContent = (DivTag)((DivTag)TagCreator.div().with((DomContent)TagCreator.div((DomContent[])new DomContent[]{Bootstrap4FormHtml.render((HtmlForm)form)}))).withClasses(new String[]{"card card-body bg-light control-group"});
        DivTag pageContent = (DivTag)((DivTag)((DivTag)TagCreator.div().with((DomContent)introContent)).with((DomContent)formContent)).withClass("container-fluid");
        return this.bootstrap4PageFactory.startBuilder(this.request).withTitle("Datarouter - Permission Request").withContent((DomContent)pageContent).withScript(TagCreator.script((String)HtmlFormTimezoneSelect.TIMEZONE_JS)).buildMav();
    }

    @BaseHandler.Handler
    public String getUserTimezone() {
        DatarouterUser user = this.getCurrentUser();
        return user.getZoneId().map(ZoneId::getId).orElse(null);
    }

    @BaseHandler.Handler
    public void setTimezone(String timezone) {
        DatarouterUser user = this.getCurrentUser();
        user.setZoneId(ZoneId.of(timezone));
        this.datarouterUserDao.put(user);
    }

    @BaseHandler.Handler
    private Mav submit(@Param(value="reason") String reason, @Param(value="timezone") Optional<String> timezone, Optional<String> specifics, Optional<String> allowedRoles) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        if (StringTool.isEmpty((String)reason)) {
            throw new IllegalArgumentException("Reason is required.");
        }
        String specificString = specifics.orElse("");
        DatarouterUser user = this.getCurrentUser();
        timezone.map(ZoneId::of).ifPresent(zoneId -> {
            user.setZoneId(zoneId);
            this.datarouterUserDao.put(user);
        });
        this.datarouterPermissionRequestDao.createPermissionRequest(new DatarouterPermissionRequest(user.getId(), new Date(), "reason: " + reason + ", specifics: " + specificString, null, null));
        Set additionalRecipients = Set.of();
        if (allowedRoles.isPresent()) {
            HashSet requestedRoles = new HashSet(Scanner.of((Object[])allowedRoles.get().split(",")).map(arg_0 -> ((RoleManager)this.roleManager).findRoleFromPersistentString(arg_0)).map(optionalRole -> (Role)optionalRole.orElseThrow(() -> new IllegalArgumentException("Permission request made with unknown role(s): " + (String)allowedRoles.get()))).list());
            additionalRecipients = this.roleManager.getAdditionalPermissionRequestEmailRecipients(user, requestedRoles);
        }
        this.sendRequestEmail(user, reason, specificString, additionalRecipients);
        if (user.getRoles().size() > 1) {
            return new InContextRedirectMav(this.request, this.paths.home);
        }
        return this.showForm(Optional.empty(), Optional.empty());
    }

    @BaseHandler.Handler
    private Mav declineAll(Optional<Long> userId, Optional<String> redirectPath) {
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new MessageMav(this.noDatarouterAuthentication());
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (!userId.orElse(currentUser.getId()).equals(currentUser.getId()) && !currentUser.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole())) {
            return new MessageMav("You do not have permission to decline this request.");
        }
        this.datarouterPermissionRequestDao.declineAll(userId.orElse(currentUser.getId()));
        DatarouterUser editedUser = currentUser;
        if (!userId.orElse(currentUser.getId()).equals(this.getCurrentUser().getId())) {
            editedUser = this.datarouterUserInfo.getUserById(userId.get(), true).get();
        }
        this.sendDeclineEmail(editedUser, currentUser);
        if (redirectPath.isEmpty()) {
            if (currentUser.getRoles().size() > 1) {
                return new InContextRedirectMav(this.request, this.paths.home);
            }
            return this.showForm(Optional.empty(), Optional.empty());
        }
        return new GlobalRedirectMav(redirectPath.get());
    }

    @BaseHandler.Handler
    private SuccessAndMessageDto declinePermissionRequests(String userId) {
        long userIdLong = Long.parseLong(userId);
        if (!this.authenticationConfig.useDatarouterAuthentication()) {
            return new SuccessAndMessageDto(false, this.noDatarouterAuthentication());
        }
        DatarouterUser currentUser = this.getCurrentUser();
        if (userIdLong != currentUser.getId() && !currentUser.getRoles().contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole())) {
            return new SuccessAndMessageDto(false, "You do not have permission to decline this request.");
        }
        this.datarouterPermissionRequestDao.declineAll(userIdLong);
        DatarouterUser editedUser = currentUser;
        if (userIdLong != this.getCurrentUser().getId()) {
            editedUser = this.datarouterUserInfo.getUserById(userIdLong, true).get();
        }
        this.sendDeclineEmail(editedUser, currentUser);
        return new SuccessAndMessageDto();
    }

    private DatarouterUser getCurrentUser() {
        return this.datarouterUserService.getAndValidateCurrentUser(this.getSessionInfo().getRequiredSession());
    }

    private void sendRequestEmail(DatarouterUser user, String reason, String specifics, Set<String> additionalRecipients) {
        String userEmail = user.getUsername();
        String primaryHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.admin.editUser.toSlashedString()).withParam("userId", "" + user.getId()).build();
        TableTag table = (TableTag)TagCreator.table((DomContent[])new DomContent[]{((TbodyTag)((TbodyTag)TagCreator.tbody().with((DomContent)DatarouterPermissionRequestHandler.createLabelValueTr("Service", new DomContent[]{TagCreator.text((String)this.serviceName.get())}).with(this.userInfoSupplier.get().getUserInformation(user)))).with((DomContent)DatarouterPermissionRequestHandler.createLabelValueTr("Reason", new DomContent[]{TagCreator.text((String)reason)}))).condWith(StringTool.notEmpty((String)specifics), (DomContent)DatarouterPermissionRequestHandler.createLabelValueTr("Specifics", new DomContent[]{TagCreator.text((String)specifics)}))}).withStyle("border-spacing: 0");
        DivTag content = TagCreator.div((DomContent[])new DomContent[]{table, TagCreator.p((DomContent[])new DomContent[]{TagCreator.a((String)"Edit user profile").withHref(primaryHref)})});
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(user)).withTitle(EMAIL_TITLE).withTitleHref(primaryHref).withContent((DomContent)content).from(userEmail).to(userEmail).to(additionalRecipients).to((SimpleEmailType)this.permissionRequestEmailType, this.serverTypeDetector.mightBeProduction()).toAdmin(this.serverTypeDetector.mightBeDevelopment());
        if (((Boolean)this.subscribersSettings.includeSubscribers.get()).booleanValue()) {
            emailBuilder.toSubscribers();
        }
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    private void sendDeclineEmail(DatarouterUser editedUser, DatarouterUser currentUser) {
        String titleHref = this.htmlEmailService.startLinkBuilder().withLocalPath(this.paths.admin.editUser.toSlashedString()).withParam("userId", "" + editedUser.getId()).build();
        String message = String.format("Permission requests declined for user %s by user %s", editedUser.getUsername(), currentUser.getUsername());
        PTag content = TagCreator.p((String)message);
        J2HtmlDatarouterEmailBuilder emailBuilder = this.htmlEmailService.startEmailBuilder().withSubject(this.userEditService.getPermissionRequestEmailSubject(editedUser)).withTitle(EMAIL_TITLE).withTitleHref(titleHref).withContent((DomContent)content).from(editedUser.getUsername()).to(editedUser.getUsername()).to((SimpleEmailType)this.permissionRequestEmailType, this.serverTypeDetector.mightBeProduction()).toSubscribers(this.serverTypeDetector.mightBeProduction()).toAdmin(this.serverTypeDetector.mightBeDevelopment());
        this.htmlEmailService.trySendJ2Html(emailBuilder);
    }

    public static TrTag createLabelValueTr(String label, DomContent ... values) {
        return (TrTag)TagCreator.tr((DomContent[])new DomContent[]{TagCreator.td((DomContent[])new DomContent[]{TagCreator.b((String)(String.valueOf(label) + ' '))}).withStyle("text-align: right"), ((TdTag)TagCreator.td().with(values)).withStyle("padding-left: 8px")}).withStyle("vertical-align: top");
    }

    private String noDatarouterAuthentication() {
        logger.warn("{} went to non-DR permission request page.", (Object)this.getSessionInfo().getRequiredSession().getUsername());
        return "This is only available when using datarouter authentication. Please email " + this.adminEmail.get() + " for assistance.";
    }

    public static class PermissionRequestDto {
        public final String requestTime;
        public final Long requestTimeMs;
        public final String requestText;
        public final String resolutionTime;
        public final Long resolutionTimeMs;
        public final String resolution;
        public final String editor;

        public PermissionRequestDto(Instant requestTime, String requestText, Optional<Instant> resolutionTime, String resolution, ZoneId zoneId, String editor) {
            this.requestTime = ZonedDateFormatterTool.formatInstantWithZone((Instant)requestTime, (ZoneId)zoneId);
            this.requestTimeMs = requestTime.toEpochMilli();
            this.requestText = requestText;
            this.resolutionTime = resolutionTime.map(instant -> ZonedDateFormatterTool.formatInstantWithZone((Instant)instant, (ZoneId)zoneId)).orElse(null);
            this.resolutionTimeMs = resolutionTime.map(Instant::toEpochMilli).orElse(null);
            this.resolution = resolution;
            this.editor = editor;
        }
    }

    private static class SuccessAndMessageDto {
        public final Boolean success;
        public final String message;

        protected SuccessAndMessageDto() {
            this.success = true;
            this.message = "";
        }

        protected SuccessAndMessageDto(boolean success, String message) {
            this.success = success;
            this.message = Objects.requireNonNull(message);
        }
    }
}

