/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.AccountCallerTypeRegistry2;
import io.datarouter.auth.service.DatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.auth.service.DatarouterAccountDeleteAction;
import io.datarouter.auth.service.DefaultDatarouterAccountAvailableEndpointsProvider;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermission;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.httpclient.endpoint.caller.CallerType;
import io.datarouter.httpclient.endpoint.param.RequestBody;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.instrumentation.metric.MetricLinkBuilder;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.secret.op.SecretOpReason;
import io.datarouter.secretweb.service.WebSecretOpReason;
import io.datarouter.storage.config.properties.DatarouterServerTypeSupplier;
import io.datarouter.storage.servertype.ServerType;
import io.datarouter.util.Require;
import io.datarouter.util.lang.ReflectionTool;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.dispatcher.ApiKeyPredicate;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.requirejs.DatarouterWebRequireJs;
import io.datarouter.web.user.session.CurrentUserSessionInfoService;
import io.datarouter.web.user.session.service.Session;
import jakarta.inject.Inject;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.servlet.ServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatarouterAccountManagerHandler
extends BaseHandler {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountManagerHandler.class);
    public static final String CHANGELOG_TYPE = "DatarouterAccount";
    private final BaseDatarouterAccountDao datarouterAccountDao;
    private final BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao;
    private final DatarouterAccountCredentialService acccountCredentialService;
    private final DatarouterServerTypeSupplier serverType;
    private final DatarouterAuthFiles files;
    private final DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider;
    private final Bootstrap4ReactPageFactory reactPageFactory;
    private final ChangelogRecorder changelogRecorder;
    private final MetricLinkBuilder metricLinkBuilder;
    private final CurrentUserSessionInfoService currentSessionInfoService;
    private final DatarouterAccountDeleteAction datarouterAccountDeleteAction;
    private final AccountCallerTypeRegistry2 callerTypeRegistry;
    private final DatarouterAuthPaths datarouterAuthPaths;
    private final String path;

    @Inject
    public DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterAccountCredentialService acccountCredentialService, DatarouterServerTypeSupplier serverType, DatarouterAuthFiles files, DatarouterAuthPaths paths, DefaultDatarouterAccountAvailableEndpointsProvider defaultDatarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, ChangelogRecorder changelogRecorder, MetricLinkBuilder metricLinkBuilder, CurrentUserSessionInfoService currentSessionInfoService, DatarouterAccountDeleteAction datarouterAccountDeleteAction, AccountCallerTypeRegistry2 callerTypeRegistry, DatarouterAuthPaths datarouterAuthPaths) {
        this(datarouterAccountDao, datarouterAccountPermissionDao, acccountCredentialService, serverType, files, defaultDatarouterAccountAvailableEndpointsProvider, reactPageFactory, changelogRecorder, metricLinkBuilder, currentSessionInfoService, datarouterAccountDeleteAction, callerTypeRegistry, datarouterAuthPaths, paths.datarouter.accountManager.toSlashedString());
    }

    protected DatarouterAccountManagerHandler(BaseDatarouterAccountDao datarouterAccountDao, BaseDatarouterAccountPermissionDao datarouterAccountPermissionDao, DatarouterAccountCredentialService acccountCredentialService, DatarouterServerTypeSupplier serverType, DatarouterAuthFiles files, DatarouterAccountAvailableEndpointsProvider datarouterAccountAvailableEndpointsProvider, Bootstrap4ReactPageFactory reactPageFactory, ChangelogRecorder changelogRecorder, MetricLinkBuilder metricLinkBuilder, CurrentUserSessionInfoService currentSessionInfoService, DatarouterAccountDeleteAction datarouterAccountDeleteAction, AccountCallerTypeRegistry2 callerTypeRegistry, DatarouterAuthPaths datarouterAuthPaths, String path) {
        this.datarouterAccountDao = datarouterAccountDao;
        this.datarouterAccountPermissionDao = datarouterAccountPermissionDao;
        this.acccountCredentialService = acccountCredentialService;
        this.serverType = serverType;
        this.files = files;
        this.datarouterAccountAvailableEndpointsProvider = datarouterAccountAvailableEndpointsProvider;
        this.reactPageFactory = reactPageFactory;
        this.changelogRecorder = changelogRecorder;
        this.metricLinkBuilder = metricLinkBuilder;
        this.currentSessionInfoService = currentSessionInfoService;
        this.datarouterAccountDeleteAction = datarouterAccountDeleteAction;
        this.callerTypeRegistry = callerTypeRegistry;
        this.datarouterAuthPaths = datarouterAuthPaths;
        this.path = path;
    }

    @BaseHandler.Handler(defaultHandler=true)
    public Mav index() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter Account Manager").withRequires(new String[]{DatarouterWebRequireJs.SORTTABLE}).withReactScript(this.files.js.accountManagerJsx).withJsStringConstant("REACT_BASE_PATH", String.valueOf(this.request.getContextPath()) + this.path + "/").withJsStringConstant("RENAMER_PATH", String.valueOf(this.request.getContextPath()) + this.datarouterAuthPaths.datarouter.accounts.renameAccounts.toSlashedString()).withJsStringConstant("CALLER_TYPE_PATH", String.valueOf(this.request.getContextPath()) + this.datarouterAuthPaths.datarouter.accounts.updateCallerType.toSlashedString()).buildMav();
    }

    @BaseHandler.Handler
    public List<DatarouterAccountDetailsDto> list() {
        return (List)this.datarouterAccountDao.scan().listTo(this::getDetailsForAccounts);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto getDetails(String accountName) {
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto add(String accountName, String callerType) {
        Require.isFalse((boolean)accountName.isEmpty());
        String creator = this.getSessionInfo().getRequiredSession().getUsername();
        DatarouterAccount account = new DatarouterAccount(accountName, new Date(), creator);
        account.setCallerType(callerType);
        this.datarouterAccountDao.put(account);
        this.logAndRecordAction(accountName, "add");
        return this.getDetailsForAccounts(List.of(account)).get(0);
    }

    @BaseHandler.Handler
    public List<String> getAvailableCallerTypes() {
        return this.callerTypeRegistry.get().stream().map(ReflectionTool::create).map(CallerType::getName).sorted().collect(Collectors.toList());
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto toggleUserMappings(String accountName) {
        return this.modifyAccount("toggleUserMappings", accountName, DatarouterAccount::toggleUserMappings);
    }

    @BaseHandler.Handler
    public void delete(String accountName) {
        DatarouterAccountPermissionKey prefix = new DatarouterAccountPermissionKey(accountName);
        this.datarouterAccountPermissionDao.deleteWithPrefix(prefix);
        this.acccountCredentialService.deleteAllCredentialsForAccount(accountName, this.getSessionInfo().getRequiredSession());
        DatarouterAccountKey accountKey = new DatarouterAccountKey(accountName);
        DatarouterAccount account = this.datarouterAccountDao.get(accountKey);
        this.datarouterAccountDeleteAction.onDelete(account);
        this.datarouterAccountDao.delete(accountKey);
        this.logAndRecordAction(accountName, "delete");
    }

    @BaseHandler.Handler
    public List<DatarouterAccountCredentialService.AccountLookupDto> lookupAccount(String apiKey) {
        return this.acccountCredentialService.lookupAccountName(apiKey);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto addCredential(String accountName) {
        Require.isFalse((boolean)accountName.isEmpty());
        String creatorUsername = this.getSessionInfo().getRequiredSession().getUsername();
        DatarouterAccountCredentialService.AccountKey accountKey = this.acccountCredentialService.createCredential(accountName, creatorUsername);
        this.logAndRecordAction(accountName, "addCredential", DatarouterAccountManagerHandler.getCredentialNote(accountKey.apiKey));
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto deleteCredential(String apiKey, String accountName) {
        this.acccountCredentialService.deleteCredential(apiKey);
        this.logAndRecordAction(accountName, "deleteCredential", DatarouterAccountManagerHandler.getCredentialNote(apiKey));
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsAndKeypairDto addSecretCredential(String accountName) {
        Require.isFalse((boolean)accountName.isEmpty());
        Session session = this.getSessionInfo().getRequiredSession();
        String creatorUsername = session.getUsername();
        SecretOpReason secretOpReason = WebSecretOpReason.manualOp((Session)session, (String)((Object)((Object)this)).getClass().getSimpleName());
        DatarouterAccountCredentialService.AccountKey accountKey = this.acccountCredentialService.createSecretCredential(accountName, creatorUsername, secretOpReason);
        this.logAndRecordAction(accountName, "addSecretCredential", DatarouterAccountManagerHandler.getSecretCredentialNote(accountKey.secretName, accountKey.apiKey));
        return new DatarouterAccountDetailsAndKeypairDto(this.getDetailsForAccountName(accountName), accountKey.getDatarouterAccountSecretCredentialKeypairDto());
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto deleteSecretCredential(String secretName, String accountName) {
        SecretOpReason secretOpReason = WebSecretOpReason.manualOp((Session)this.getSessionInfo().getRequiredSession(), (String)((Object)((Object)this)).getClass().getSimpleName());
        this.acccountCredentialService.deleteSecretCredential(secretName, secretOpReason);
        this.logAndRecordAction(accountName, "deleteSecretCredential", DatarouterAccountManagerHandler.getSecretCredentialNote(secretName));
        return this.getDetailsForAccountName(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto setCredentialActivation(@RequestBody SetCredentialActivationDto dto) {
        String active;
        Require.notBlank((String)this.accountName);
        Require.notNull((Object)dto.active);
        String string = active = dto.active != false ? "Active" : "Inactive";
        if (dto.secretName != null && StringTool.notEmptyNorWhitespace((String)dto.secretName)) {
            this.acccountCredentialService.setSecretCredentialActivation(dto.secretName, dto.active);
            this.logAndRecordAction(dto.accountName, "setSecretCredential" + active, DatarouterAccountManagerHandler.getSecretCredentialNote(dto.secretName));
        } else if (dto.apiKey != null && StringTool.notEmptyNorWhitespace((String)dto.apiKey)) {
            this.acccountCredentialService.setCredentialActivation(dto.apiKey, dto.active);
            this.logAndRecordAction(dto.accountName, "setCredential" + active, DatarouterAccountManagerHandler.getCredentialNote(dto.apiKey));
        } else {
            throw new RuntimeException("apiKey or secretName is required");
        }
        return this.getDetails(dto.accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto updateReferrer(String accountName, String referrer) {
        return this.modifyAccount("updateReferrer", accountName, account -> account.setReferrer(referrer));
    }

    @BaseHandler.Handler
    public List<String> getAvailableEndpoints() {
        ArrayList<String> availableEndpoints = new ArrayList<String>();
        availableEndpoints.add("all");
        availableEndpoints.addAll(this.datarouterAccountAvailableEndpointsProvider.getAvailableEndpoints());
        return availableEndpoints;
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto addPermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.put(new DatarouterAccountPermission(accountName, endpoint));
        this.logAndRecordAction(accountName, "addPermission", Optional.of(endpoint));
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public DatarouterAccountDetailsDto deletePermission(String accountName, String endpoint) {
        this.datarouterAccountPermissionDao.delete(new DatarouterAccountPermissionKey(accountName, endpoint));
        this.logAndRecordAction(accountName, "deletePermission", Optional.of(endpoint));
        return this.getDetails(accountName);
    }

    @BaseHandler.Handler
    public boolean isServerTypeDev() {
        return StringTool.equalsCaseInsensitive((String)this.serverType.getServerTypeString(), (String)ServerType.DEV.getPersistentString());
    }

    private DatarouterAccountDetailsDto modifyAccount(String action, String accountName, Consumer<DatarouterAccount> editor) {
        DatarouterAccountKey key = new DatarouterAccountKey(Require.notBlank((String)accountName));
        DatarouterAccount account = this.datarouterAccountDao.get(key);
        editor.accept(account);
        this.datarouterAccountDao.put(account);
        this.logAndRecordAction(accountName, action);
        return this.getDetailsForAccountName(accountName);
    }

    private List<DatarouterAccountDetailsDto> getDetailsForAccounts(List<DatarouterAccount> accounts) {
        ZoneId zoneId = this.currentSessionInfoService.getZoneId((ServletRequest)this.request);
        Set accountNames = (Set)Scanner.of(accounts).map(BaseDatabean::getKey).map(DatarouterAccountKey::getAccountName).collect(HashSet::new);
        Map<String, List<AccountCredentialDto>> credentialsByAccountName = this.acccountCredentialService.getCredentialsByAccountName(accountNames, zoneId);
        Map<String, List<DatarouterAccountCredentialService.SecretCredentialDto>> secretCredentialsByAccountName = this.acccountCredentialService.getSecretCredentialsByAccountName(accountNames, zoneId);
        Map permissionsByAccountName = ((Scanner)Scanner.of((Iterable)accountNames).map(DatarouterAccountPermissionKey::new).listTo(this.datarouterAccountPermissionDao::scanKeysWithPrefixes)).map(TextPermissionDto::new).groupBy(permission -> permission.accountName);
        return Scanner.of(accounts).map(account -> new AccountDto((DatarouterAccount)((Object)account), zoneId)).map(account -> this.getDetailsForAccount((AccountDto)account, (List)credentialsByAccountName.get(account.accountName), (List)secretCredentialsByAccountName.get(account.accountName), (List)permissionsByAccountName.get(account.accountName))).list();
    }

    private DatarouterAccountDetailsDto getDetailsForAccount(AccountDto account, List<AccountCredentialDto> credentials, List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials, List<TextPermissionDto> permissions) {
        String counterName = "Datarouter account name " + account.accountName;
        String metricLink = this.metricLinkBuilder.exactMetricLink(counterName);
        return new DatarouterAccountDetailsDto(account, credentials, secretCredentials, permissions, metricLink);
    }

    public DatarouterAccountDetailsDto getDetailsForAccountName(String accountName) {
        DatarouterAccount account = this.datarouterAccountDao.get(new DatarouterAccountKey(accountName));
        return this.getDetailsForAccounts(List.of(account)).get(0);
    }

    private void logAndRecordAction(String account, String action) {
        this.logAndRecordAction(account, action, Optional.empty());
    }

    private void logAndRecordAction(String account, String action, Optional<String> note) {
        String username = this.getSessionInfo().getNonEmptyUsernameOrElse("unknown");
        logger.warn("account={} action={} by={} note: {}", new Object[]{account, action, username, note.orElse("none")});
        ChangelogRecorder.DatarouterChangelogDtoBuilder changelogBuilder = new ChangelogRecorder.DatarouterChangelogDtoBuilder(CHANGELOG_TYPE, account, action, username);
        note.ifPresent(arg_0 -> ((ChangelogRecorder.DatarouterChangelogDtoBuilder)changelogBuilder).withNote(arg_0));
        this.changelogRecorder.record(changelogBuilder.build());
    }

    private static Optional<String> getCredentialNote(String apiKey) {
        return Optional.of("apiKey=" + ApiKeyPredicate.obfuscate((String)apiKey));
    }

    private static Optional<String> getSecretCredentialNote(String secretName) {
        return Optional.of("secretName=" + secretName);
    }

    private static Optional<String> getSecretCredentialNote(String secretName, String apiKey) {
        return Optional.of(String.valueOf(DatarouterAccountManagerHandler.getSecretCredentialNote(secretName).get()) + " " + DatarouterAccountManagerHandler.getCredentialNote(apiKey).get());
    }

    public record AccountCredentialDto(String apiKey, String secretKey, String accountName, String created, String creatorUsername, String lastUsed, Boolean active) {
        public AccountCredentialDto(DatarouterAccountCredential credential, ZoneId zoneId) {
            this(((DatarouterAccountCredentialKey)credential.getKey()).getApiKey(), credential.getSecretKey(), credential.getAccountName(), credential.getCreatedDate(zoneId), credential.getCreatorUsername(), credential.getLastUsedDate(zoneId), credential.getActive());
        }
    }

    public record AccountDto(String accountName, String created, String creator, String lastUsed, Boolean enableUserMappings, String callerType, String referrer, long lastUsedMs) {
        public AccountDto(DatarouterAccount account, ZoneId zoneId) {
            this(((DatarouterAccountKey)account.getKey()).getAccountName(), account.getCreatedDate(zoneId), account.getCreator(), account.getLastUsedDate(zoneId), account.getEnableUserMappings(), account.getCallerType(), account.getReferrer(), Optional.ofNullable(account.getLastUsed()).map(Date::getTime).orElse(0L));
        }
    }

    public record DatarouterAccountDetailsAndKeypairDto(DatarouterAccountDetailsDto details, DatarouterAccountCredentialService.DatarouterAccountSecretCredentialKeypairDto keypair) {
    }

    public static final class DatarouterAccountDetailsDto
    extends Record {
        private final AccountDto account;
        private final List<AccountCredentialDto> credentials;
        private final List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials;
        private final List<TextPermissionDto> permissions;
        private final String metricLink;
        private final String error;

        public DatarouterAccountDetailsDto(AccountDto account, List<AccountCredentialDto> credentials, List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials, List<TextPermissionDto> permissions, String metricLink) {
            this(account, Objects.requireNonNullElseGet(credentials, List::of), Objects.requireNonNullElseGet(secretCredentials, List::of), Objects.requireNonNullElseGet(permissions, List::of), metricLink, null);
        }

        public DatarouterAccountDetailsDto(String error) {
            this(null, null, null, null, null, error);
        }

        public AccountDto account() {
            return this.account;
        }

        public List<AccountCredentialDto> credentials() {
            return this.credentials;
        }

        public List<DatarouterAccountCredentialService.SecretCredentialDto> secretCredentials() {
            return this.secretCredentials;
        }

        public List<TextPermissionDto> permissions() {
            return this.permissions;
        }

        public String metricLink() {
            return this.metricLink;
        }

        public String error() {
            return this.error;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{DatarouterAccountDetailsDto.class, "account;credentials;secretCredentials;permissions;metricLink;error", "account", "credentials", "secretCredentials", "permissions", "metricLink", "error"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{DatarouterAccountDetailsDto.class, "account;credentials;secretCredentials;permissions;metricLink;error", "account", "credentials", "secretCredentials", "permissions", "metricLink", "error"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{DatarouterAccountDetailsDto.class, "account;credentials;secretCredentials;permissions;metricLink;error", "account", "credentials", "secretCredentials", "permissions", "metricLink", "error"}, this, object);
        }

        public DatarouterAccountDetailsDto(AccountDto accountDto, List list, List list2, List list3, String string, String string2) {
            this.account = accountDto;
            this.credentials = list;
            this.secretCredentials = list2;
            this.permissions = list3;
            this.metricLink = string;
            this.error = string2;
        }
    }

    public record SetCredentialActivationDto(String apiKey, String secretName, Boolean active, String accountName) {
    }

    public record TextPermissionDto(String accountName, String endpoint) {
        public TextPermissionDto(DatarouterAccountPermissionKey permission) {
            this(permission.getAccountName(), permission.getEndpoint());
        }
    }
}

