/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service.deprovisioning;

import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.deprovisioning.UserDeprovisioningStrategy;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.role.RoleManager;
import io.datarouter.web.user.session.service.UserSessionService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

@Singleton
public class DatarouterUserDeprovisioningStrategy
implements UserDeprovisioningStrategy {
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DatarouterUserHistoryService datarouterUserHistoryService;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private RoleManager roleManager;
    @Inject
    private UserSessionService userSessionService;

    @Override
    public List<String> flagUsers(List<String> usernames, Optional<String> editorUsername) {
        return this.doFlagOrDeprovision(usernames, false, editorUsername);
    }

    @Override
    public List<String> deprovisionUsers(List<String> usernames, Optional<String> editorUsername) {
        return this.doFlagOrDeprovision(usernames, true, editorUsername);
    }

    private List<String> doFlagOrDeprovision(List<String> usernames, boolean shouldDeprovision, Optional<String> editorUsername) {
        this.userSessionService.deleteUserSessions(usernames);
        ArrayList<DeprovisionedUser> deprovisionedUsers = new ArrayList<DeprovisionedUser>();
        List users = (List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername);
        ArrayList<String> deprovisionedUsernames = new ArrayList<String>();
        users.forEach(user -> {
            deprovisionedUsers.add(new DeprovisionedUser(user.getUsername(), user.getRoles(), shouldDeprovision ? DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED : DeprovisionedUser.UserDeprovisioningStatus.FLAGGED));
            user.setRoles(List.of());
            user.setEnabled(Boolean.valueOf(false));
            deprovisionedUsernames.add(user.getUsername());
        });
        this.deprovisionedUserDao.putMulti(deprovisionedUsers);
        if (shouldDeprovision) {
            Optional<DatarouterUser> editor = editorUsername.map(DatarouterUser.DatarouterUserByUsernameLookup::new).map(this.datarouterUserDao::getByUsername);
            this.datarouterUserDao.putMulti(users);
            this.datarouterUserHistoryService.recordDeprovisions(users, editor);
        }
        return deprovisionedUsernames;
    }

    @Override
    public List<String> restoreUsers(List<String> usernames, Optional<String> editorUsername) {
        Set validRoles = this.roleManager.getAllRoles();
        Map deprovisionedRolesByUsername = ((Scanner)Scanner.of(usernames).map(DeprovisionedUserKey::new).listTo(this.deprovisionedUserDao::scanWithPrefixes)).include(user -> user.getStatus() == DeprovisionedUser.UserDeprovisioningStatus.DEPROVISIONED).toMap(DeprovisionedUser::getUsername, DeprovisionedUser::getRoles);
        Map datarouterUserByUsername = ((List)Scanner.of(usernames).map(DatarouterUser.DatarouterUserByUsernameLookup::new).listTo(this.datarouterUserDao::getMultiByUsername)).stream().collect(Collectors.toMap(DatarouterUser::getUsername, Function.identity()));
        Scanner normalUsersToRestore = Scanner.of(usernames).include(deprovisionedRolesByUsername::containsKey).include(datarouterUserByUsername::containsKey).map(username -> {
            List rolesToRestore = ((Set)deprovisionedRolesByUsername.get(username)).stream().filter(validRoles::contains).collect(Collectors.toList());
            DatarouterUser datarouterUser = (DatarouterUser)datarouterUserByUsername.get(username);
            datarouterUser.setRoles(rolesToRestore);
            datarouterUser.setEnabled(Boolean.valueOf(true));
            return datarouterUser;
        });
        Scanner unrecordedUsersToRestore = Scanner.of(usernames).exclude(deprovisionedRolesByUsername::containsKey).include(datarouterUserByUsername::containsKey).map(username -> {
            DatarouterUser datarouterUser = (DatarouterUser)datarouterUserByUsername.get(username);
            HashSet rolesToRestore = new HashSet(this.roleManager.getDefaultRoles());
            rolesToRestore.addAll(datarouterUser.getRoles());
            datarouterUser.setRoles(rolesToRestore);
            datarouterUser.setEnabled(Boolean.valueOf(true));
            return datarouterUser;
        });
        return normalUsersToRestore.append(unrecordedUsersToRestore).flush(this.datarouterUserDao::putMulti).flush(this.buildRecordRestoreConsumer(editorUsername)).map(DatarouterUser::getUsername).flush(this.deprovisionedUserDao::deleteMultiUsernames).list();
    }

    private Consumer<List<DatarouterUser>> buildRecordRestoreConsumer(Optional<String> editorUsername) {
        Optional<DatarouterUser> editor = editorUsername.map(DatarouterUser.DatarouterUserByUsernameLookup::new).map(this.datarouterUserDao::getByUsername);
        return users -> this.datarouterUserHistoryService.recordRestores((List<DatarouterUser>)users, editor);
    }
}

