/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.model.dto.RoleApprovalRequirementStatus;
import io.datarouter.auth.model.dto.UserRoleMetadata;
import io.datarouter.auth.model.dto.UserRoleUpdateDto;
import io.datarouter.auth.model.enums.RoleUpdateType;
import io.datarouter.auth.service.DatarouterAccountUserService;
import io.datarouter.auth.service.DatarouterUserHistoryService;
import io.datarouter.auth.service.DatarouterUserService;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApproval;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApprovalDao;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMap;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.EnvironmentName;
import io.datarouter.storage.config.properties.ServiceName;
import io.datarouter.util.BooleanTool;
import io.datarouter.web.user.DatarouterSessionDao;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.role.DatarouterUserRole;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleApprovalType;
import io.datarouter.web.user.role.RoleManager;
import io.datarouter.web.util.PasswordTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterUserEditService {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterUserEditService.class);
    @Inject
    private BaseDatarouterUserAccountMapDao datarouterUserAccountMapDao;
    @Inject
    private DatarouterUserHistoryService userHistoryService;
    @Inject
    private DatarouterSessionDao datarouterSessionDao;
    @Inject
    private DatarouterUserService datarouterUserService;
    @Inject
    private ServiceName serviceName;
    @Inject
    private EnvironmentName environmentName;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterUserRoleApprovalDao userRoleApprovalDao;
    @Inject
    private DatarouterAccountUserService datarouterAccountUserService;

    public Optional<String> editRoles(DatarouterUser editor, DatarouterUser user, List<UserRoleUpdateDto> updates, String signinUrl) {
        Optional<UserRoleUpdateDto> datarouterAdminUpdate = updates.stream().filter(update -> DatarouterUserRole.DATAROUTER_ADMIN.getPersistentString().equals(update.roleName())).findFirst();
        if (datarouterAdminUpdate.isPresent() && RoleUpdateType.REVOKE.equals((Object)datarouterAdminUpdate.get().updateType()) && !user.equals((Object)editor)) {
            throw new RuntimeException("cannot revoke another's datarouterAdmin role");
        }
        Map userRoleMetadataByRole = Scanner.of(this.datarouterUserService.getRoleMetadataForUser(editor, user)).toMap(UserRoleMetadata::role);
        ArrayList<String> changes = new ArrayList<String>();
        ArrayList<UserRoleUpdateDto> failedUpdates = new ArrayList<UserRoleUpdateDto>();
        for (UserRoleUpdateDto updateDto : updates) {
            Optional roleToUpdateOptional = this.roleManager.findRoleFromPersistentString(updateDto.roleName());
            if (roleToUpdateOptional.isEmpty()) {
                logger.warn("Role update attempted for {} by {} for unknown role={}", new Object[]{user.getUsername(), editor.getUsername(), updateDto.roleName()});
                continue;
            }
            Role roleToUpdate = (Role)roleToUpdateOptional.get();
            if (!userRoleMetadataByRole.containsKey(roleToUpdate)) {
                logger.warn("Role update attempted for {} by {} for non-conferrable role={}", new Object[]{user.getUsername(), editor.getUsername(), updateDto.roleName()});
                continue;
            }
            UserRoleMetadata userRoleMetadata = (UserRoleMetadata)userRoleMetadataByRole.get(roleToUpdate);
            Optional<UserRoleMetadata> optionalUpdatedRoleMetadata = this.attemptRoleUpdate(editor, user, userRoleMetadata, updateDto.updateType());
            if (optionalUpdatedRoleMetadata.isPresent()) {
                UserRoleMetadata updatedRoleMetadata = optionalUpdatedRoleMetadata.get();
                userRoleMetadataByRole.put(roleToUpdate, updatedRoleMetadata);
                changes.add(updatedRoleMetadata.getChangeString(userRoleMetadata));
                continue;
            }
            failedUpdates.add(updateDto);
        }
        user.setRoles((Collection)userRoleMetadataByRole.entrySet().stream().filter(entry -> ((UserRoleMetadata)entry.getValue()).privilegesGranted()).map(Map.Entry::getKey).collect(Collectors.toSet()));
        if (!changes.isEmpty()) {
            this.userHistoryService.putAndRecordEdit(user, editor, this.getRolesChangesString(changes), signinUrl);
            this.datarouterSessionDao.scan().include(session -> session.getUserToken().equals(user.getUserToken())).each(session -> session.setRoles(user.getRoles())).flush(arg_0 -> ((DatarouterSessionDao)this.datarouterSessionDao).putMulti(arg_0));
        }
        return failedUpdates.isEmpty() ? Optional.empty() : Optional.of("Failed to update some roles: " + failedUpdates);
    }

    private String getRolesChangesString(List<String> changes) {
        String changesStr = "roles updated: [";
        changesStr = changes.size() == 1 ? String.valueOf(changesStr) + changes.get(0) + "]" : String.valueOf(changesStr) + "\n\t" + String.join((CharSequence)",\n\t", changes) + "\n]";
        return changesStr;
    }

    private Optional<UserRoleMetadata> attemptRoleUpdate(DatarouterUser editor, DatarouterUser user, UserRoleMetadata userRoleMetadata, RoleUpdateType updateType) {
        return switch (updateType) {
            case RoleUpdateType.APPROVE -> this.attemptRoleApproval(editor, user, userRoleMetadata);
            case RoleUpdateType.UNAPPROVE -> this.attemptRoleUnapproval(editor, user, userRoleMetadata);
            case RoleUpdateType.REVOKE -> this.attemptRoleRevocation(editor, user, userRoleMetadata);
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private Optional<UserRoleMetadata> attemptRoleApproval(DatarouterUser editor, DatarouterUser user, UserRoleMetadata userRoleMetadata) {
        if (userRoleMetadata.editorPrioritizedApprovalType().isEmpty()) {
            logger.warn("Attempt to approve role={} for user={} which editor={} cannot approve", new Object[]{userRoleMetadata.role(), user.getUsername(), editor.getUsername()});
            return Optional.empty();
        }
        RoleApprovalType editorPrioritizedApprovalType = userRoleMetadata.editorPrioritizedApprovalType().get();
        if (userRoleMetadata.privilegesGranted()) {
            logger.warn("Attempt to approve already granted role={} for user={} by editor={}", new Object[]{userRoleMetadata.role(), user.getUsername(), editor.getUsername()});
            return Optional.empty();
        }
        boolean editorAlreadyApproved = userRoleMetadata.requirementStatusByApprovalType().values().stream().anyMatch(requirementStatus -> requirementStatus.currentApprovers().contains(editor.getUsername()));
        if (editorAlreadyApproved) {
            logger.warn("Attempt to doubly approve role={} for user={} by editor={}", new Object[]{userRoleMetadata.role(), user.getUsername(), editor.getUsername()});
            return Optional.empty();
        }
        Map requirementStatusByApprovalTypeSnapshot = Scanner.of(userRoleMetadata.requirementStatusByApprovalType().entrySet()).toMap(Map.Entry::getKey, entry -> new RoleApprovalRequirementStatus(((RoleApprovalRequirementStatus)entry.getValue()).requiredApprovals(), new HashSet<String>(((RoleApprovalRequirementStatus)entry.getValue()).currentApprovers())));
        ((RoleApprovalRequirementStatus)requirementStatusByApprovalTypeSnapshot.get(editorPrioritizedApprovalType)).currentApprovers().add(editor.getUsername());
        boolean areAllRequirementsMet = requirementStatusByApprovalTypeSnapshot.values().stream().allMatch(requirement -> requirement.requiredApprovals() == requirement.currentApprovers().size());
        UserRoleMetadata updatedRoleMetadata = new UserRoleMetadata(userRoleMetadata.role(), areAllRequirementsMet, requirementStatusByApprovalTypeSnapshot, userRoleMetadata.editorPrioritizedApprovalType(), null);
        DatarouterUserRoleApproval userRoleApproval = new DatarouterUserRoleApproval(user.getUsername(), userRoleMetadata.role().persistentString, editor.getUsername(), Instant.now(), editorPrioritizedApprovalType.persistentString(), null);
        this.userRoleApprovalDao.put(userRoleApproval);
        if (areAllRequirementsMet) {
            this.userRoleApprovalDao.setAllRequirementsMetAtForUserRole(user, userRoleMetadata.role().persistentString);
        }
        return Optional.of(updatedRoleMetadata);
    }

    private Optional<UserRoleMetadata> attemptRoleUnapproval(DatarouterUser editor, DatarouterUser user, UserRoleMetadata userRoleMetadata) {
        if (userRoleMetadata.privilegesGranted()) {
            logger.warn("Attempt to unapprove already granted role={} for {} by {}", new Object[]{userRoleMetadata.role(), user.getUsername(), editor.getUsername()});
            return Optional.empty();
        }
        AtomicBoolean unapproved = new AtomicBoolean(false);
        Map<RoleApprovalType, RoleApprovalRequirementStatus> updatedRequirementStatusByApprovalType = userRoleMetadata.requirementStatusByApprovalType().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Set<String> updatedCurrentApprovers = ((RoleApprovalRequirementStatus)entry.getValue()).currentApprovers().stream().filter(approver -> !editor.getUsername().equals(approver)).collect(Collectors.toSet());
            if (!updatedCurrentApprovers.equals(((RoleApprovalRequirementStatus)entry.getValue()).currentApprovers())) {
                unapproved.set(true);
            }
            return new RoleApprovalRequirementStatus(((RoleApprovalRequirementStatus)entry.getValue()).requiredApprovals(), updatedCurrentApprovers);
        }));
        if (!unapproved.get()) {
            logger.warn("Attempt to unapprove role={} for user={} by editor={} where no approval had previously been given", new Object[]{userRoleMetadata.role(), user.getUsername(), editor.getUsername()});
            return Optional.empty();
        }
        this.userRoleApprovalDao.deleteOutstandingApprovals(user, userRoleMetadata.role().persistentString, editor);
        return Optional.of(new UserRoleMetadata(userRoleMetadata.role(), false, updatedRequirementStatusByApprovalType, userRoleMetadata.editorPrioritizedApprovalType(), null));
    }

    private Optional<UserRoleMetadata> attemptRoleRevocation(DatarouterUser editor, DatarouterUser user, UserRoleMetadata userRoleMetadata) {
        if (!userRoleMetadata.privilegesGranted()) {
            logger.warn("Attempt by editor={} to revoke role={} which user={} did not have", new Object[]{editor.getUsername(), userRoleMetadata.role(), user.getUsername()});
            return Optional.empty();
        }
        return Optional.of(new UserRoleMetadata(userRoleMetadata.role(), false, new HashMap<RoleApprovalType, RoleApprovalRequirementStatus>(), userRoleMetadata.editorPrioritizedApprovalType(), null));
    }

    public void editUser(DatarouterUser user, DatarouterUser editor, Boolean enabled, String signinUrl, Set<DatarouterAccountKey> requestedAccounts, Optional<ZoneId> optionalZoneId, Optional<String> description) {
        ArrayList<String> changes = new ArrayList<String>();
        HashSet currentRoles = new HashSet(user.getRoles());
        boolean isUserDatarouterAdmin = currentRoles.contains(DatarouterUserRole.DATAROUTER_ADMIN.getRole());
        boolean shouldDeleteSessions = false;
        if (enabled != null && !BooleanTool.nullSafeSame((Boolean)enabled, (Boolean)user.getEnabled())) {
            if (isUserDatarouterAdmin) {
                throw new RuntimeException("cannot disable datarouterAdmin user");
            }
            changes.add(DatarouterUserEditService.change("enabled", user.getEnabled(), enabled));
            user.setEnabled(enabled);
            shouldDeleteSessions = true;
        }
        this.handleAccountChanges(user, requestedAccounts).ifPresent(changes::add);
        optionalZoneId.ifPresent(zoneId -> {
            boolean sameZoneId;
            Optional currentZoneId = user.getZoneId();
            boolean bl = sameZoneId = currentZoneId.isPresent() && ((ZoneId)currentZoneId.get()).equals(zoneId);
            if (!sameZoneId) {
                user.setZoneId(zoneId);
                changes.add(DatarouterUserEditService.change("timezone", currentZoneId.map(ZoneId::getId).orElse(""), zoneId.getId()));
            }
        });
        if (changes.size() > 0 || description.isPresent()) {
            String colon = changes.size() > 0 && description.isPresent() ? ": " : "";
            String changesStr = String.valueOf(description.orElse("")) + colon + String.join((CharSequence)", ", changes);
            this.userHistoryService.putAndRecordEdit(user, editor, changesStr, signinUrl);
            if (shouldDeleteSessions) {
                this.datarouterSessionDao.scan().include(session -> session.getUserToken().equals(user.getUserToken())).map(BaseDatabean::getKey).flush(arg_0 -> ((DatarouterSessionDao)this.datarouterSessionDao).deleteMulti(arg_0));
            }
        } else {
            logger.warn("User {} submitted edit request for user {}, but no changes were made.", (Object)editor, (Object)user);
        }
    }

    public Map<String, Boolean> editAccounts(DatarouterUser editor, DatarouterUser user, Map<String, Boolean> updates, String signinUrl) {
        Set requestedAccounts = (Set)Scanner.of(updates.entrySet()).include(Map.Entry::getValue).map(Map.Entry::getKey).map(DatarouterAccountKey::new).collect(HashSet::new);
        String changes = this.handleAccountChanges(user, requestedAccounts).orElseThrow();
        this.userHistoryService.putAndRecordEdit(user, editor, changes, signinUrl);
        return this.datarouterAccountUserService.getAccountProvisioningStatusForUser(user);
    }

    private Optional<String> handleAccountChanges(DatarouterUser user, Set<DatarouterAccountKey> requestedAccounts) {
        Set currentAccounts = (Set)this.datarouterUserAccountMapDao.scanKeysWithPrefix(new DatarouterUserAccountMapKey(user.getId(), null)).collect(HashSet::new);
        Set<DatarouterUserAccountMapKey> accountsToDelete = currentAccounts.stream().filter(currentAccountKey -> !requestedAccounts.contains((Object)currentAccountKey.getDatarouterAccountKey())).collect(Collectors.toSet());
        Set<DatarouterUserAccountMap> accountsToAdd = requestedAccounts.stream().map(accountKey -> new DatarouterUserAccountMap(user.getId(), accountKey.getAccountName())).filter(requestedAccount -> !currentAccounts.contains(requestedAccount.getKey())).collect(Collectors.toSet());
        if (!accountsToDelete.isEmpty() || !accountsToAdd.isEmpty()) {
            if (!accountsToDelete.isEmpty()) {
                this.datarouterUserAccountMapDao.deleteMulti(accountsToDelete);
            }
            if (!accountsToAdd.isEmpty()) {
                this.datarouterUserAccountMapDao.putMulti(accountsToAdd);
            }
            Set original = (Set)Scanner.of((Iterable)currentAccounts).map(DatarouterUserAccountMapKey::getDatarouterAccountKey).map(DatarouterAccountKey::getAccountName).collect(HashSet::new);
            Set current = (Set)Scanner.of(requestedAccounts).map(DatarouterAccountKey::getAccountName).collect(HashSet::new);
            return Optional.of(DatarouterUserEditService.changeList("account", original, current));
        }
        return Optional.empty();
    }

    public void updateTimeZone(DatarouterUser editor, DatarouterUser user, String timeZoneId, String signInUrl) {
        boolean sameZoneId;
        Optional currentZoneId = user.getZoneId();
        ZoneId newZoneId = ZoneId.of(timeZoneId);
        boolean bl = sameZoneId = currentZoneId.isPresent() && ((ZoneId)currentZoneId.get()).equals(newZoneId);
        if (sameZoneId) {
            logger.warn("Attempt to update time zone with same time zone");
            return;
        }
        user.setZoneId(newZoneId);
        String changeStr = DatarouterUserEditService.change("timezone", currentZoneId.map(ZoneId::getId).orElse(""), newZoneId.getId());
        this.userHistoryService.putAndRecordEdit(user, editor, changeStr, signInUrl);
    }

    public void changePassword(DatarouterUser user, DatarouterUser editor, String newPassword, String signinUrl) {
        this.updateUserPassword(user, newPassword);
        this.userHistoryService.putAndRecordPasswordChange(user, editor, signinUrl);
    }

    public static String changeList(String name, Set<String> before, Set<String> after) {
        List added = Scanner.of(after).exclude(before::contains).sort().list();
        List removed = Scanner.of(before).exclude(after::contains).sort().list();
        String output = String.valueOf(DatarouterUserEditService.generateChangeOutput(added, name, "added")) + DatarouterUserEditService.generateChangeOutput(removed, name, "removed");
        return output.length() == 0 ? "No changes" : output.trim();
    }

    private static String generateChangeOutput(List<String> updates, String name, String description) {
        if (updates.isEmpty()) {
            return "";
        }
        return String.valueOf(name) + (updates.size() > 1 ? "s" : "") + " " + description + ": [" + String.join((CharSequence)", ", updates) + "] ";
    }

    private void updateUserPassword(DatarouterUser user, String password) {
        String passwordSalt = PasswordTool.generateSalt();
        String passwordDigest = PasswordTool.digest((String)passwordSalt, (String)password);
        user.setPasswordSalt(passwordSalt);
        user.setPasswordDigest(passwordDigest);
    }

    private static String change(String name, Object before, Object after) {
        return String.valueOf(name) + ": " + before + " => " + after;
    }

    public String getPermissionRequestEmailSubject(DatarouterUser user) {
        return String.format("Permission Request %s - %s - %s", user.getUsername(), this.environmentName.get(), this.serviceName.get());
    }
}

