/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.httpclient.security.DefaultSignatureGenerator;
import io.datarouter.web.security.DefaultSignatureValidator;
import io.datarouter.web.security.SecurityValidationResult;
import io.datarouter.web.security.SignatureValidator;
import io.datarouter.web.util.http.RequestTool;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DatarouterAccountSignatureValidator
implements SignatureValidator {
    private static final Logger logger = LoggerFactory.getLogger(DatarouterAccountSignatureValidator.class);
    private final String apiKeyFieldName;
    private final DatarouterAccountCredentialService datarouterAccountCredentialService;

    @Inject
    public DatarouterAccountSignatureValidator(DatarouterAccountCredentialService datarouterAccountCredentialService) {
        this("apiKey", datarouterAccountCredentialService);
    }

    private DatarouterAccountSignatureValidator(String apiKeyFieldName, DatarouterAccountCredentialService datarouterAccountCredentialService) {
        this.apiKeyFieldName = apiKeyFieldName;
        this.datarouterAccountCredentialService = datarouterAccountCredentialService;
    }

    public SecurityValidationResult validate(HttpServletRequest request) {
        String apiKey = RequestTool.getParameterOrHeader((HttpServletRequest)request, (String)this.apiKeyFieldName);
        Optional<String> optionalSecretKey = this.datarouterAccountCredentialService.findSecretKeyForApiKeyAuth(apiKey);
        if (optionalSecretKey.isEmpty()) {
            logger.warn("Missing account for apiKey={}", (Object)apiKey);
        }
        return optionalSecretKey.map(secretKey -> () -> secretKey).map(DefaultSignatureGenerator::new).map(DefaultSignatureValidator::new).map(signatureValidator -> signatureValidator.validate(request)).orElse(SecurityValidationResult.failure((HttpServletRequest)request));
    }

    @Singleton
    public static class DatarouterAccountSignatureValidatorFactory {
        @Inject
        private DatarouterAccountCredentialService datarouterAccountCredentialService;

        public DatarouterAccountSignatureValidator create(String apiKeyFieldName) {
            return new DatarouterAccountSignatureValidator(apiKeyFieldName, this.datarouterAccountCredentialService);
        }
    }
}

