/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.config.DatarouterAuthSettingRoot;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.email.html.J2HtmlEmailTable;
import io.datarouter.pathnode.PathNode;
import io.datarouter.web.digest.DailyDigest;
import io.datarouter.web.digest.DailyDigestGrouping;
import io.datarouter.web.digest.DailyDigestService;
import io.datarouter.web.html.j2html.J2HtmlTable;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.H3Tag;
import j2html.tags.specialized.SmallTag;
import j2html.tags.specialized.TableTag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.util.List;
import java.util.Optional;

@Singleton
public class DatarouterAccountDailyDigest
implements DailyDigest {
    private static final Instant THRESHOLD = Instant.now().minus(Duration.ofDays(365L));
    private static final SmallTag CAPTION = TagCreator.small((String)"Old Accounts or Accounts without a callerType");
    @Inject
    private DatarouterAccountDao accountDao;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DailyDigestService digestService;
    @Inject
    private DatarouterAuthSettingRoot settings;

    private List<DatarouterAccount> getAccounts() {
        return this.accountDao.scan().include(account -> account.getLastUsedInstant().isBefore(THRESHOLD) || account.getCallerType() == null).list();
    }

    public Optional<DivTag> getPageContent(ZoneId zoneId) {
        if (!((Boolean)this.settings.enableAccountDailyDigest.get()).booleanValue()) {
            return Optional.empty();
        }
        List<DatarouterAccount> accounts = this.getAccounts();
        if (accounts.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Accounts", (PathNode)this.paths.datarouter.accountManager);
        TableTag table = DatarouterAccountDailyDigest.buildTable(accounts, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, CAPTION, table}));
    }

    public Optional<DivTag> getEmailContent(ZoneId zoneId) {
        if (!((Boolean)this.settings.enableAccountDailyDigest.get()).booleanValue()) {
            return Optional.empty();
        }
        List<DatarouterAccount> accounts = this.getAccounts();
        if (accounts.isEmpty()) {
            return Optional.empty();
        }
        H3Tag header = this.digestService.makeHeader("Old Accounts", (PathNode)this.paths.datarouter.accountManager);
        TableTag table = DatarouterAccountDailyDigest.buildEmailTable(accounts, zoneId);
        return Optional.of(TagCreator.div((DomContent[])new DomContent[]{header, CAPTION, table}));
    }

    public DailyDigestGrouping getGrouping() {
        return DailyDigestGrouping.LOW;
    }

    public String getTitle() {
        return "Accounts";
    }

    public DailyDigest.DailyDigestType getType() {
        return DailyDigest.DailyDigestType.ACTIONABLE;
    }

    private static TableTag buildTable(List<DatarouterAccount> rows, ZoneId zoneId) {
        return new J2HtmlTable().withClasses(new String[]{"sortable table table-sm table-striped my-4 border"}).withColumn("Account", row -> ((DatarouterAccountKey)row.getKey()).getAccountName()).withColumn("Creator", DatarouterAccount::getCreator).withColumn("Created", row -> row.getCreatedDate(zoneId)).withColumn("Last Used", row -> row.getLastUsedDate(zoneId)).withColumn("Caller Type", DatarouterAccount::getCallerType).build(rows);
    }

    private static TableTag buildEmailTable(List<DatarouterAccount> rows, ZoneId zoneId) {
        return new J2HtmlEmailTable().withColumn("Account", row -> ((DatarouterAccountKey)row.getKey()).getAccountName()).withColumn("Creator", DatarouterAccount::getCreator).withColumn("Created", row -> row.getCreatedDate(zoneId)).withColumn("Last Used", row -> row.getLastUsedDate(zoneId)).withColumn("Caller Type", DatarouterAccount::getCallerType).build(rows);
    }
}

