/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.instrumentation.count.Counters;
import jakarta.inject.Singleton;

@Singleton
public class DatarouterAccountCounters {
    public static final String ACCOUNT = "account";
    public static final String NAME = "name";
    private static final String ENDPOINT = "endpoint";
    private final String prefix;

    public DatarouterAccountCounters() {
        this(ACCOUNT);
    }

    public DatarouterAccountCounters(String prefix) {
        this.prefix = prefix;
    }

    public void incPermissionUsage(DatarouterAccountPermissionKey permission) {
        this.incInternal(NAME, permission.getAccountName());
        this.incInternal(ENDPOINT, permission.getEndpoint(), permission.getAccountName());
    }

    private void incInternal(String format, String ... suffixes) {
        Counters.inc((String)("Datarouter " + this.prefix + " " + format + " " + String.join((CharSequence)" ", suffixes)));
    }
}

