/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.model.dto;

import io.datarouter.auth.model.dto.RoleApprovalRequirementStatus;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleApprovalType;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public record UserRoleMetadata(Role role, boolean privilegesGranted, Map<RoleApprovalType, RoleApprovalRequirementStatus> requirementStatusByApprovalType, Optional<RoleApprovalType> editorPrioritizedApprovalType, Optional<Boolean> editorCanRevoke) {
    public String getChangeString(UserRoleMetadata oldRoleMetaData) {
        if (!Objects.equals(this.role, oldRoleMetaData.role)) {
            return null;
        }
        if (this.privilegesGranted && !oldRoleMetaData.privilegesGranted) {
            return this.role + ": granted (prior approvals=" + oldRoleMetaData.requirementStatusByApprovalType.toString() + ")";
        }
        if (!this.privilegesGranted && oldRoleMetaData.privilegesGranted()) {
            return this.role + ": revoked";
        }
        return "%1$s: approval change %2$s => %3$s".formatted(this.role, oldRoleMetaData.requirementStatusByApprovalType.toString(), this.requirementStatusByApprovalType.toString());
    }

    public UserRoleMetadataJsDto toJsDto() {
        return new UserRoleMetadataJsDto(this.role.persistentString, this.role.description, this.privilegesGranted, Scanner.of(this.requirementStatusByApprovalType.keySet()).toMap(RoleApprovalType::persistentString, this.requirementStatusByApprovalType::get), this.editorPrioritizedApprovalType.map(RoleApprovalType::persistentString).orElse(null), this.editorCanRevoke.orElse(null));
    }

    public record UserRoleMetadataJsDto(String roleName, String roleDescription, boolean privilegesGranted, Map<String, RoleApprovalRequirementStatus> requirementStatusByApprovalType, String editorPrioritizedApprovalType, Boolean editorCanRevoke) {
    }
}

