/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.job;

import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistory;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.instrumentation.changelog.ChangelogRecorder;
import io.datarouter.instrumentation.task.TaskTracker;
import io.datarouter.job.BaseJob;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.config.properties.AdminEmail;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.role.Role;
import io.datarouter.web.user.role.RoleManager;
import jakarta.inject.Inject;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DeletedRoleCleanupJob
extends BaseJob {
    @Inject
    private AdminEmail adminEmail;
    @Inject
    private ChangelogRecorder changelogRecorder;
    @Inject
    private RoleManager roleManager;
    @Inject
    private DatarouterUserDao userDao;
    @Inject
    private DatarouterUserHistoryDao userHistoryDao;

    public void run(TaskTracker tracker) {
        Set roles = this.roleManager.getAllRoles();
        this.userDao.scan().exclude(datarouterUser -> roles.containsAll(datarouterUser.getRoles())).batch(100).map(batch -> Scanner.of((Iterable)batch).map(user -> {
            Set deletedRoles = (Set)Scanner.of((Iterable)user.getRoles()).exclude(roles::contains).collect(HashSet::new);
            user.removeRoles((Collection)deletedRoles);
            List removedRolePersistentStrings = Scanner.of((Iterable)deletedRoles).map(Role::getPersistentString).list();
            String changes = "Removed deleted role types: " + removedRolePersistentStrings;
            DatarouterUserHistory userHistory = new DatarouterUserHistory(user.getId(), Instant.now(), 1L, DatarouterUserHistory.DatarouterUserChangeType.EDIT, changes);
            ChangelogRecorder.DatarouterChangelogDto changelogEntry = new ChangelogRecorder.DatarouterChangelogDtoBuilder("DatarouterUserHistory", user.getUsername(), DatarouterUserHistory.DatarouterUserChangeType.EDIT.persistentString, this.adminEmail.get()).withComment(changes).build();
            return new DeletedRoleCleanupDto((DatarouterUser)user, userHistory, changelogEntry);
        }).list()).forEach(batch -> {
            this.userDao.putMulti(Scanner.of((Iterable)batch).map(DeletedRoleCleanupDto::updatedUser).list());
            this.userHistoryDao.putMulti(Scanner.of((Iterable)batch).map(DeletedRoleCleanupDto::historyEntry).list());
            Scanner.of((Iterable)batch).map(DeletedRoleCleanupDto::changelogEntry).forEach(arg_0 -> ((ChangelogRecorder)this.changelogRecorder).record(arg_0));
        });
    }

    private record DeletedRoleCleanupDto(DatarouterUser updatedUser, DatarouterUserHistory historyEntry, ChangelogRecorder.DatarouterChangelogDto changelogEntry) {
    }
}

