/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.config;

import com.google.inject.binder.ScopedBindingBuilder;
import io.datarouter.auth.config.ApiDocsNavBarItem;
import io.datarouter.auth.config.CreateUserNavBarItem;
import io.datarouter.auth.config.DatarouterAccountApiRouteSet;
import io.datarouter.auth.config.DatarouterAccountConfigAppListener;
import io.datarouter.auth.config.DatarouterAccountRouteSet;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.config.DatarouterAuthRouteSet;
import io.datarouter.auth.config.DatarouterAuthSettingRoot;
import io.datarouter.auth.config.DatarouterAuthTriggerGroup;
import io.datarouter.auth.config.DatarouterUserConfigAppListener;
import io.datarouter.auth.config.UserDeprovisioningRouteSet;
import io.datarouter.auth.service.AccountCallerTypeRegistry2;
import io.datarouter.auth.service.CopyUserListener;
import io.datarouter.auth.service.DatarouterAccountDailyDigest;
import io.datarouter.auth.service.DatarouterAccountDeleteAction;
import io.datarouter.auth.service.DatarouterDefaultAccountKeysDailyDigest;
import io.datarouter.auth.service.DatarouterDefaultUserDailyDigest;
import io.datarouter.auth.service.DatarouterPermissionRequestUserInfo;
import io.datarouter.auth.service.DatarouterUserInfo;
import io.datarouter.auth.service.DefaultDatarouterAccountKeys;
import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.service.DefaultDatarouterUserPassword;
import io.datarouter.auth.service.DefaultDatarouterUserPasswordSupplier;
import io.datarouter.auth.service.PermissionRequestDailyDigest;
import io.datarouter.auth.service.PermissionRequestUserInfo;
import io.datarouter.auth.service.UserInfo;
import io.datarouter.auth.service.deprovisioning.DatarouterUserDeprovisioningStrategy;
import io.datarouter.auth.service.deprovisioning.UserDeprovisioningStrategy;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.BaseDatarouterAccountSecretCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccountSecretCredentialDao;
import io.datarouter.auth.storage.accountpermission.BaseDatarouterAccountPermissionDao;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionDao;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestDao;
import io.datarouter.auth.storage.roleapprovals.DatarouterUserRoleApprovalDao;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.auth.storage.useraccountmap.BaseDatarouterUserAccountMapDao;
import io.datarouter.auth.storage.useraccountmap.DatarouterUserAccountMapDao;
import io.datarouter.auth.storage.userhistory.DatarouterUserHistoryDao;
import io.datarouter.auth.web.DatarouterDocumentationRouteSet;
import io.datarouter.httpclient.endpoint.caller.CallerType;
import io.datarouter.job.BaseTriggerGroup;
import io.datarouter.job.config.DatarouterJobRouteSet;
import io.datarouter.pathnode.PathNode;
import io.datarouter.plugin.PluginConfigKey;
import io.datarouter.plugin.PluginConfigValue;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.Dao;
import io.datarouter.storage.dao.DaosModuleBuilder;
import io.datarouter.web.config.BaseWebPlugin;
import io.datarouter.web.navigation.AppNavBarCategory;
import io.datarouter.web.navigation.DatarouterNavBarCategory;
import io.datarouter.web.navigation.NavBarCategory;
import io.datarouter.web.user.BaseDatarouterSessionDao;
import io.datarouter.web.user.DatarouterSessionDao;
import io.datarouter.web.user.authenticate.saml.BaseDatarouterSamlDao;
import io.datarouter.web.user.authenticate.saml.DatarouterSamlDao;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DatarouterAuthPlugin
extends BaseWebPlugin {
    private static final DatarouterAuthPaths PATHS = new DatarouterAuthPaths();
    private final Class<? extends UserDeprovisioningStrategy> userDeprovisioningStrategyClass;
    private final Class<? extends CopyUserListener> copyUserListenerClass;
    private final String defaultDatarouterUserPassword;
    private final String defaultApiKey;
    private final String defaultSecretKey;
    private final Optional<Class<? extends DatarouterAccountDeleteAction>> datarouterAccountDeleteAction;
    private final List<Class<? extends CallerType>> callerTypes2;

    private DatarouterAuthPlugin(boolean enableUserAuth, DatarouterAuthDaoModule daosModuleBuilder, Class<? extends UserDeprovisioningStrategy> userDeprovisioningStrategyClass, Class<? extends CopyUserListener> copyUserListenerClass, String defaultDatarouterUserPassword, String defaultApiKey, String defaultSecretKey, Optional<Class<? extends DatarouterAccountDeleteAction>> datarouterAccountDeleteAction, List<Class<? extends CallerType>> callerTypes2, Map<PluginConfigKey<?>, Class<? extends PluginConfigValue<?>>> configs) {
        this.userDeprovisioningStrategyClass = userDeprovisioningStrategyClass;
        this.copyUserListenerClass = copyUserListenerClass;
        this.defaultDatarouterUserPassword = defaultDatarouterUserPassword;
        this.defaultApiKey = defaultApiKey;
        this.defaultSecretKey = defaultSecretKey;
        this.datarouterAccountDeleteAction = datarouterAccountDeleteAction;
        this.callerTypes2 = callerTypes2;
        if (enableUserAuth) {
            this.addAppListener(DatarouterUserConfigAppListener.class);
            this.addAppNavBarItem((NavBarCategory)AppNavBarCategory.USER, DatarouterAuthPlugin.PATHS.admin.viewUsers, "View Users");
            this.addAppNavBarItem((NavBarCategory)AppNavBarCategory.USER, DatarouterAuthPlugin.PATHS.admin.editUser, "Edit User");
            this.addAppNavBarItem((NavBarCategory)AppNavBarCategory.USER, (PathNode)DatarouterAuthPlugin.PATHS.permissionRequest, "Permission Request");
            this.addDynamicNavBarItem(CreateUserNavBarItem.class);
            this.addRouteSetOrdered(DatarouterAuthRouteSet.class, DatarouterJobRouteSet.class);
        }
        this.addAppListener(DatarouterAccountConfigAppListener.class);
        this.addDatarouterNavBarItem((NavBarCategory)DatarouterNavBarCategory.CONFIGURATION, DatarouterAuthPlugin.PATHS.datarouter.accountManager, "Accounts");
        this.addAppNavBarItem((NavBarCategory)AppNavBarCategory.USER, DatarouterAuthPlugin.PATHS.userDeprovisioning, "User Deprovisioning");
        this.addDynamicNavBarItem(ApiDocsNavBarItem.class);
        this.addRouteSet(DatarouterAccountApiRouteSet.class);
        this.addRouteSet(DatarouterAccountRouteSet.class);
        this.addRouteSet(DatarouterDocumentationRouteSet.class);
        this.addRouteSet(UserDeprovisioningRouteSet.class);
        this.addSettingRoot(DatarouterAuthSettingRoot.class);
        this.addPluginEntry(BaseTriggerGroup.KEY, DatarouterAuthTriggerGroup.class);
        this.setDaosModule(daosModuleBuilder);
        this.addDatarouterGithubDocLink("datarouter-auth");
        this.addDailyDigest(PermissionRequestDailyDigest.class);
        this.addDailyDigest(DatarouterAccountDailyDigest.class);
        this.addDailyDigest(DatarouterDefaultAccountKeysDailyDigest.class);
        this.addDailyDigest(DatarouterDefaultUserDailyDigest.class);
        configs.forEach((arg_0, arg_1) -> ((DatarouterAuthPlugin)this).addPluginEntry(arg_0, arg_1));
    }

    protected void configure() {
        this.bindActual(BaseDatarouterSessionDao.class, DatarouterSessionDao.class);
        this.bindActual(BaseDatarouterAccountDao.class, DatarouterAccountDao.class);
        this.bindActual(BaseDatarouterAccountCredentialDao.class, DatarouterAccountCredentialDao.class);
        this.bindActual(BaseDatarouterAccountSecretCredentialDao.class, DatarouterAccountSecretCredentialDao.class);
        this.bindActual(BaseDatarouterAccountPermissionDao.class, DatarouterAccountPermissionDao.class);
        this.bindActual(BaseDatarouterUserAccountMapDao.class, DatarouterUserAccountMapDao.class);
        this.bindActual(BaseDatarouterSamlDao.class, DatarouterSamlDao.class);
        this.bind(UserDeprovisioningStrategy.class).to(this.userDeprovisioningStrategyClass);
        this.bindActual(CopyUserListener.class, this.copyUserListenerClass);
        this.bindActualInstance(DefaultDatarouterUserPasswordSupplier.class, new DefaultDatarouterUserPassword(this.defaultDatarouterUserPassword));
        this.bindActualInstance(DefaultDatarouterAccountKeysSupplier.class, new DefaultDatarouterAccountKeys(this.defaultApiKey, this.defaultSecretKey));
        this.datarouterAccountDeleteAction.ifPresent(clazz -> {
            ScopedBindingBuilder scopedBindingBuilder = this.bind(DatarouterAccountDeleteAction.class).to(clazz);
        });
        this.bindActualInstance(AccountCallerTypeRegistry2.class, new AccountCallerTypeRegistry2(this.callerTypes2));
    }

    public static class DatarouterAuthDaoModule
    extends DaosModuleBuilder {
        private final List<ClientId> datarouterAccountClientIds;
        private final List<ClientId> datarouterAccountCredentialClientIds;
        private final List<ClientId> datarouterAccountSecretCredentialClientIds;
        private final List<ClientId> datarouterAccountPermissionClientIds;
        private final List<ClientId> datarouterPermissionRequestClientIds;
        private final List<ClientId> datarouterSamlClientIds;
        private final List<ClientId> datarouterUserAccountMapClientIds;
        private final List<ClientId> datarouterUserClientIds;
        private final List<ClientId> datarouterUserHistoryClientIds;
        private final List<ClientId> deprovisionedUserClientIds;
        private final List<ClientId> datarouterUserRoleApprovalClientIds;

        public DatarouterAuthDaoModule(List<ClientId> datarouterAccountClientIds, List<ClientId> datarouterAccountCredentialClientIds, List<ClientId> datarouterAccountSecretCredentialClientIds, List<ClientId> datarouterAccountPermissionClientIds, List<ClientId> datarouterPermissionRequestClientIds, List<ClientId> datarouterSamlClientIds, List<ClientId> datarouterUserAccountMapClientIds, List<ClientId> datarouterUserClientIds, List<ClientId> datarouterUserHistoryClientIds, List<ClientId> deprovisionedUserClientIds, List<ClientId> datarouterUserRoleApprovalClientIds) {
            this.datarouterAccountClientIds = datarouterAccountClientIds;
            this.datarouterAccountCredentialClientIds = datarouterAccountCredentialClientIds;
            this.datarouterAccountSecretCredentialClientIds = datarouterAccountSecretCredentialClientIds;
            this.datarouterAccountPermissionClientIds = datarouterAccountPermissionClientIds;
            this.datarouterPermissionRequestClientIds = datarouterPermissionRequestClientIds;
            this.datarouterSamlClientIds = datarouterSamlClientIds;
            this.datarouterUserAccountMapClientIds = datarouterUserAccountMapClientIds;
            this.datarouterUserClientIds = datarouterUserClientIds;
            this.datarouterUserHistoryClientIds = datarouterUserHistoryClientIds;
            this.deprovisionedUserClientIds = deprovisionedUserClientIds;
            this.datarouterUserRoleApprovalClientIds = datarouterUserRoleApprovalClientIds;
        }

        public List<Class<? extends Dao>> getDaoClasses() {
            return List.of(DatarouterAccountDao.class, DatarouterAccountCredentialDao.class, DatarouterAccountSecretCredentialDao.class, DatarouterAccountPermissionDao.class, DatarouterPermissionRequestDao.class, DatarouterUserAccountMapDao.class, DatarouterUserDao.class, DatarouterUserHistoryDao.class, DatarouterSamlDao.class, DeprovisionedUserDao.class, DatarouterUserRoleApprovalDao.class);
        }

        public void configure() {
            this.bind(DatarouterUserDao.DatarouterUserDaoParams.class).toInstance((Object)new DatarouterUserDao.DatarouterUserDaoParams(this.datarouterUserClientIds));
            this.bind(DatarouterUserHistoryDao.DatarouterUserHistoryDaoParams.class).toInstance((Object)new DatarouterUserHistoryDao.DatarouterUserHistoryDaoParams(this.datarouterUserHistoryClientIds));
            this.bind(DatarouterPermissionRequestDao.DatarouterPermissionRequestDaoParams.class).toInstance((Object)new DatarouterPermissionRequestDao.DatarouterPermissionRequestDaoParams(this.datarouterPermissionRequestClientIds));
            this.bind(DatarouterAccountDao.DatarouterAccountDaoParams.class).toInstance((Object)new DatarouterAccountDao.DatarouterAccountDaoParams(this.datarouterAccountClientIds));
            this.bind(DatarouterAccountCredentialDao.DatarouterAccountCredentialDaoParams.class).toInstance((Object)new DatarouterAccountCredentialDao.DatarouterAccountCredentialDaoParams(this.datarouterAccountCredentialClientIds));
            this.bind(DatarouterAccountSecretCredentialDao.DatarouterAccountSecretCredentialDaoParams.class).toInstance((Object)new DatarouterAccountSecretCredentialDao.DatarouterAccountSecretCredentialDaoParams(this.datarouterAccountSecretCredentialClientIds));
            this.bind(DatarouterAccountPermissionDao.DatarouterAccountPermissionDaoParams.class).toInstance((Object)new DatarouterAccountPermissionDao.DatarouterAccountPermissionDaoParams(this.datarouterAccountPermissionClientIds));
            this.bind(DatarouterUserAccountMapDao.DatarouterUserAccountMapDaoParams.class).toInstance((Object)new DatarouterUserAccountMapDao.DatarouterUserAccountMapDaoParams(this.datarouterUserAccountMapClientIds));
            this.bind(DatarouterSamlDao.DatarouterSamlDaoParams.class).toInstance((Object)new DatarouterSamlDao.DatarouterSamlDaoParams(this.datarouterSamlClientIds));
            this.bind(DeprovisionedUserDao.DeprovisionedUserDaoParams.class).toInstance((Object)new DeprovisionedUserDao.DeprovisionedUserDaoParams(this.deprovisionedUserClientIds));
            this.bind(DatarouterUserRoleApprovalDao.DatarouterUserRoleApprovalDaoParams.class).toInstance((Object)new DatarouterUserRoleApprovalDao.DatarouterUserRoleApprovalDaoParams(this.datarouterUserRoleApprovalClientIds));
        }
    }

    public static class DatarouterAuthPluginBuilder {
        private final boolean enableUserAuth;
        private final List<ClientId> defaultClientId;
        private Map<PluginConfigKey<?>, Class<? extends PluginConfigValue<?>>> configs = new HashMap();
        private Class<? extends UserDeprovisioningStrategy> userDeprovisioningStrategyClass = DatarouterUserDeprovisioningStrategy.class;
        private Class<? extends CopyUserListener> copyUserListenerClass = CopyUserListener.DefaultCopyUserListener.class;
        private String defaultDatarouterUserPassword = "";
        private String defaultApiKey = "";
        private String defaultSecretKey = "";
        private Optional<Class<? extends DatarouterAccountDeleteAction>> datarouterAccountDeleteAction = Optional.empty();
        private List<Class<? extends CallerType>> callerTypes2 = new ArrayList<Class<? extends CallerType>>();

        public DatarouterAuthPluginBuilder(boolean enableUserAuth, List<ClientId> defaultClientId, String defaultDatarouterUserPassword, String defaultApiKey, String defaultSecretKey) {
            this.enableUserAuth = enableUserAuth;
            this.defaultClientId = defaultClientId;
            this.defaultDatarouterUserPassword = defaultDatarouterUserPassword;
            this.defaultApiKey = defaultApiKey;
            this.defaultSecretKey = defaultSecretKey;
            this.configs.put(PermissionRequestUserInfo.KEY, DatarouterPermissionRequestUserInfo.class);
            this.configs.put(UserInfo.KEY, DatarouterUserInfo.class);
        }

        public DatarouterAuthPluginBuilder setUserInfoClass(Class<? extends UserInfo> userInfoClass) {
            this.configs.put(UserInfo.KEY, userInfoClass);
            return this;
        }

        public DatarouterAuthPluginBuilder setUserDeprovisioningStrategyClass(Class<? extends UserDeprovisioningStrategy> userDeprovisioningStrategyClass) {
            this.userDeprovisioningStrategyClass = userDeprovisioningStrategyClass;
            return this;
        }

        public DatarouterAuthPluginBuilder setCopyUserListenerClass(Class<? extends CopyUserListener> copyUserListenerClass) {
            this.copyUserListenerClass = copyUserListenerClass;
            return this;
        }

        public DatarouterAuthPluginBuilder setDatarouterAccountDeleteAction(Class<? extends DatarouterAccountDeleteAction> datarouterAccountDeleteAction) {
            this.datarouterAccountDeleteAction = Optional.of(datarouterAccountDeleteAction);
            return this;
        }

        public DatarouterAuthPluginBuilder setPermissionRequestUserInfo(Class<? extends PermissionRequestUserInfo> permissionRequestUserInfo) {
            this.configs.put(PermissionRequestUserInfo.KEY, permissionRequestUserInfo);
            return this;
        }

        public DatarouterAuthPluginBuilder addCallerType2(Class<? extends CallerType> callerType2) {
            this.callerTypes2.add(callerType2);
            return this;
        }

        public DatarouterAuthPlugin build() {
            return new DatarouterAuthPlugin(this.enableUserAuth, new DatarouterAuthDaoModule(this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId, this.defaultClientId), this.userDeprovisioningStrategyClass, this.copyUserListenerClass, this.defaultDatarouterUserPassword, this.defaultApiKey, this.defaultSecretKey, this.datarouterAccountDeleteAction, this.callerTypes2, this.configs);
        }
    }
}

