/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.cache;

import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.util.cache.LoadingCache;
import io.datarouter.util.cache.LoadingCacheWrapper;
import io.datarouter.web.exception.InvalidCredentialsException;
import io.datarouter.web.user.databean.DatarouterUser;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.time.Duration;

@Singleton
public class DatarouterUserByUsernameCache
extends LoadingCacheWrapper<String, DatarouterUser> {
    @Inject
    public DatarouterUserByUsernameCache(DatarouterUserDao datarouterUserDao) {
        super(new LoadingCache.LoadingCacheBuilder().withLoadingFunction(key -> datarouterUserDao.getByUsername(new DatarouterUser.DatarouterUserByUsernameLookup(key))).withExpireTtl(Duration.ofSeconds(6L)).withExceptionFunction(key -> new InvalidCredentialsException("username not found (" + key + ")")).build());
    }
}

