/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.deprovisioneduser;

import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserKey;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.auth.web.deprovisioning.UserDeprovisioningStatusDto;
import io.datarouter.enums.PersistentString;
import io.datarouter.enums.StringEnum;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.field.Field;
import io.datarouter.model.field.imp.comparable.InstantField;
import io.datarouter.model.field.imp.comparable.InstantFieldKey;
import io.datarouter.model.field.imp.enums.StringEnumField;
import io.datarouter.model.field.imp.enums.StringEnumFieldKey;
import io.datarouter.model.field.imp.list.DelimitedStringListField;
import io.datarouter.model.field.imp.list.DelimitedStringListFieldKey;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.serialize.fielder.BaseDatabeanFielder;
import io.datarouter.web.user.session.service.Role;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class DeprovisionedUser
extends BaseDatabean<DeprovisionedUserKey, DeprovisionedUser> {
    private List<String> roles;
    private UserDeprovisioningStatus status;
    private Instant updated;

    public DeprovisionedUser() {
        super((PrimaryKey)new DeprovisionedUserKey(null));
    }

    public DeprovisionedUser(String username, Collection<Role> roles, UserDeprovisioningStatus status) {
        super((PrimaryKey)new DeprovisionedUserKey(username));
        this.setRoles(roles);
        this.status = status;
        this.updated = Instant.now();
    }

    public DeprovisionedUserDto toDto() {
        return new DeprovisionedUserDto(this.getUsername(), this.roles, this.status.dto);
    }

    public Supplier<DeprovisionedUserKey> getKeySupplier() {
        return DeprovisionedUserKey::new;
    }

    public String getUsername() {
        return ((DeprovisionedUserKey)this.getKey()).getUsername();
    }

    public Set<Role> getRoles() {
        return this.roles.stream().map(Role::new).collect(Collectors.toSet());
    }

    public void setRoles(Collection<Role> roles) {
        this.roles = roles.stream().map(Role::getPersistentString).sorted().distinct().collect(Collectors.toList());
    }

    public UserDeprovisioningStatus getStatus() {
        return this.status;
    }

    public Instant getUpdated() {
        return this.updated;
    }

    public void setUpdated(Instant updated) {
        this.updated = updated;
    }

    public static class DeprovisionedUserFielder
    extends BaseDatabeanFielder<DeprovisionedUserKey, DeprovisionedUser> {
        public DeprovisionedUserFielder() {
            super(DeprovisionedUserKey::new);
        }

        public List<Field<?>> getNonKeyFields(DeprovisionedUser user) {
            return List.of(new DelimitedStringListField(FieldKeys.roles, user.roles), new StringEnumField(FieldKeys.status, (StringEnum)user.status), new InstantField(FieldKeys.updated, user.updated));
        }
    }

    public static class FieldKeys {
        public static final DelimitedStringListFieldKey roles = new DelimitedStringListFieldKey("roles");
        public static final StringEnumFieldKey<UserDeprovisioningStatus> status = new StringEnumFieldKey("status", UserDeprovisioningStatus.class);
        public static final InstantFieldKey updated = new InstantFieldKey("updated");
    }

    public static enum UserDeprovisioningStatus implements StringEnum<UserDeprovisioningStatus>
    {
        DEPROVISIONED("deprovisioned", UserDeprovisioningStatusDto.DEPROVISIONED),
        FLAGGED("flagged", UserDeprovisioningStatusDto.FLAGGED);

        private final String persistentString;
        public final UserDeprovisioningStatusDto dto;

        private UserDeprovisioningStatus(String persistentString, UserDeprovisioningStatusDto dto) {
            this.persistentString = persistentString;
            this.dto = dto;
        }

        public String getPersistentString() {
            return this.persistentString;
        }

        public UserDeprovisioningStatus fromPersistentString(String string) {
            return UserDeprovisioningStatus.fromPersistentStringStatic(string);
        }

        public static UserDeprovisioningStatus fromPersistentStringStatic(String string) {
            return (UserDeprovisioningStatus)StringEnum.getEnumFromString((PersistentString[])UserDeprovisioningStatus.values(), (String)string, null);
        }
    }
}

