/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.user;

import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.model.key.unique.UniqueKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.config.Config;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.IndexedSortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantIndexedSortedMapStorageNode;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterUserDao
extends BaseDao {
    private final IndexedSortedMapStorage.IndexedSortedMapStorageNode<DatarouterUserKey, DatarouterUser, DatarouterUser.DatarouterUserFielder> node;

    @Inject
    public DatarouterUserDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterUserDaoParams params) {
        super(datarouter);
        this.node = (IndexedSortedMapStorage.IndexedSortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> (IndexedSortedMapStorage.IndexedSortedMapStorageNode)nodeFactory.create(clientId, DatarouterUser::new, DatarouterUser.DatarouterUserFielder::new).withTag(Tag.DATAROUTER).build()).listTo(RedundantIndexedSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public DatarouterUser get(DatarouterUserKey key) {
        return (DatarouterUser)this.node.get((PrimaryKey)key);
    }

    public DatarouterUser getByUserToken(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return (DatarouterUser)this.node.lookupUnique((UniqueKey)key);
    }

    public DatarouterUser getByUsername(DatarouterUser.DatarouterUserByUsernameLookup key) {
        return (DatarouterUser)this.node.lookupUnique((UniqueKey)key);
    }

    public List<DatarouterUser> getMulti(Collection<DatarouterUserKey> keys) {
        return this.node.getMulti(keys);
    }

    public List<DatarouterUser> getMultiByUserTokens(Collection<DatarouterUser.DatarouterUserByUserTokenLookup> keys) {
        return this.node.lookupMultiUnique(keys);
    }

    public List<DatarouterUser> getMultiByUsername(Collection<DatarouterUser.DatarouterUserByUsernameLookup> keys) {
        return this.node.lookupMultiUnique(keys);
    }

    public Optional<DatarouterUser> find(DatarouterUserKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public Optional<DatarouterUser> find(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return Optional.ofNullable((DatarouterUser)this.node.lookupUnique((UniqueKey)key));
    }

    public Scanner<DatarouterUser> scan() {
        return this.node.scan();
    }

    public void put(DatarouterUser databean) {
        this.node.put((Databean)databean);
    }

    public void putMulti(Collection<DatarouterUser> databeans) {
        this.node.putMulti(databeans);
    }

    public void delete(DatarouterUserKey key) {
        this.node.delete((PrimaryKey)key);
    }

    public void deleteMulti(Collection<DatarouterUserKey> keys) {
        this.node.deleteMulti(keys);
    }

    public boolean hasAny() {
        return this.node.scanKeys(new Config().setLimit(Integer.valueOf(1))).hasAny();
    }

    public boolean exists(DatarouterUser.DatarouterUserByUserTokenLookup key) {
        return this.node.lookupUnique((UniqueKey)key) != null;
    }

    public static class DatarouterUserDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterUserDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

