/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.permissionrequest;

import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequest;
import io.datarouter.auth.storage.permissionrequest.DatarouterPermissionRequestKey;
import io.datarouter.model.databean.BaseDatabean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterPermissionRequestDao
extends BaseDao {
    private final SortedMapStorage.SortedMapStorageNode<DatarouterPermissionRequestKey, DatarouterPermissionRequest, DatarouterPermissionRequest.DatarouterPermissionRequestFielder> node;

    @Inject
    public DatarouterPermissionRequestDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterPermissionRequestDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)nodeFactory.create(clientId, DatarouterPermissionRequest::new, DatarouterPermissionRequest.DatarouterPermissionRequestFielder::new).withTag(Tag.DATAROUTER).build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    public void putMulti(Collection<DatarouterPermissionRequest> databeans) {
        this.node.putMulti(databeans);
    }

    public Scanner<DatarouterPermissionRequest> scan() {
        return this.node.scan();
    }

    public Scanner<DatarouterPermissionRequest> scanWithPrefix(DatarouterPermissionRequestKey prefix) {
        return this.node.scanWithPrefix((PrimaryKey)prefix);
    }

    public Scanner<DatarouterPermissionRequest> scanOpenPermissionRequests() {
        return this.scan().include(request -> request.getResolution() == null);
    }

    public Scanner<DatarouterPermissionRequest> scanOpenPermissionRequestsForUser(Long userId) {
        Objects.requireNonNull(userId);
        return this.scanOpenPermissionRequestsForUsers(List.of(userId));
    }

    public Scanner<DatarouterPermissionRequest> scanOpenPermissionRequestsForUsers(List<Long> userIds) {
        return ((Scanner)Scanner.of(userIds).map(userId -> new DatarouterPermissionRequestKey((Long)userId, null)).listTo(arg_0 -> this.node.scanWithPrefixes(arg_0))).include(request -> request.getResolution() == null);
    }

    public Scanner<DatarouterPermissionRequest> scanPermissionRequestsForUser(Long userId) {
        return this.scanWithPrefix(new DatarouterPermissionRequestKey(userId, null));
    }

    public void createPermissionRequest(DatarouterPermissionRequest request) {
        this.scanOpenPermissionRequestsForUser(((DatarouterPermissionRequestKey)request.getKey()).getUserId()).map(DatarouterPermissionRequest::supercede).append((Object[])new DatarouterPermissionRequest[]{request}).flush(this::putMulti);
    }

    public void declineAll(Long userId) {
        this.scanOpenPermissionRequestsForUser(userId).map(DatarouterPermissionRequest::decline).flush(this::putMulti);
    }

    public Set<Long> getUserIdsWithPermissionRequests() {
        return (Set)this.scanOpenPermissionRequests().map(BaseDatabean::getKey).map(DatarouterPermissionRequestKey::getUserId).collect(HashSet::new);
    }

    public static class DatarouterPermissionRequestDaoParams
    extends BaseRedundantDaoParams {
        public DatarouterPermissionRequestDaoParams(List<ClientId> clientIds) {
            super(clientIds);
        }
    }
}

