/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.storage.account;

import io.datarouter.auth.storage.account.BaseDatarouterAccountDao;
import io.datarouter.auth.storage.account.DatarouterAccount;
import io.datarouter.auth.storage.account.DatarouterAccountKey;
import io.datarouter.model.databean.Databean;
import io.datarouter.model.key.primary.PrimaryKey;
import io.datarouter.scanner.Scanner;
import io.datarouter.storage.Datarouter;
import io.datarouter.storage.client.ClientId;
import io.datarouter.storage.dao.BaseDao;
import io.datarouter.storage.dao.BaseRedundantDaoParams;
import io.datarouter.storage.node.builder.NodeBuilder;
import io.datarouter.storage.node.factory.NodeFactory;
import io.datarouter.storage.node.op.combo.SortedMapStorage;
import io.datarouter.storage.tag.Tag;
import io.datarouter.util.Require;
import io.datarouter.util.string.StringTool;
import io.datarouter.virtualnode.redundant.RedundantSortedMapStorageNode;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAccountDao
extends BaseDao
implements BaseDatarouterAccountDao {
    private final SortedMapStorage.SortedMapStorageNode<DatarouterAccountKey, DatarouterAccount, DatarouterAccount.DatarouterAccountFielder> node;

    @Inject
    public DatarouterAccountDao(Datarouter datarouter, NodeFactory nodeFactory, DatarouterAccountDaoParams params) {
        super(datarouter);
        this.node = (SortedMapStorage.SortedMapStorageNode)Scanner.of((Iterable)params.clientIds).map(clientId -> {
            NodeBuilder builder = nodeFactory.create(clientId, DatarouterAccount::new, DatarouterAccount.DatarouterAccountFielder::new).withTag(Tag.DATAROUTER);
            datarouterAccountDaoParams.tableName.ifPresent(arg_0 -> ((NodeBuilder)builder).withTableName(arg_0));
            SortedMapStorage.SortedMapStorageNode node = (SortedMapStorage.SortedMapStorageNode)builder.build();
            return node;
        }).listTo(RedundantSortedMapStorageNode::makeIfMulti);
        datarouter.register(this.node);
    }

    @Override
    public void put(DatarouterAccount databean) {
        this.node.put((Databean)databean);
    }

    @Override
    public void putMulti(Collection<DatarouterAccount> databeans) {
        this.node.putMulti(databeans);
    }

    @Override
    public DatarouterAccount get(DatarouterAccountKey key) {
        return (DatarouterAccount)this.node.get((PrimaryKey)key);
    }

    @Override
    public Scanner<DatarouterAccount> scanMulti(Collection<DatarouterAccountKey> keys) {
        return this.node.scanMulti(keys);
    }

    @Override
    public Scanner<DatarouterAccount> scan() {
        return this.node.scan();
    }

    @Override
    public Scanner<DatarouterAccountKey> scanKeys() {
        return this.node.scanKeys();
    }

    @Override
    public boolean exists(DatarouterAccountKey key) {
        return this.node.exists((PrimaryKey)key);
    }

    @Override
    public void delete(DatarouterAccountKey key) {
        this.node.delete((PrimaryKey)key);
    }

    @Override
    public Optional<DatarouterAccount> find(DatarouterAccountKey key) {
        return this.node.find((PrimaryKey)key);
    }

    public static class DatarouterAccountDaoParams
    extends BaseRedundantDaoParams {
        public final Optional<String> tableName;

        public DatarouterAccountDaoParams(List<ClientId> clientIds) {
            super(clientIds);
            this.tableName = Optional.empty();
        }

        public DatarouterAccountDaoParams(List<ClientId> clientIds, String tableName) {
            super(clientIds);
            Require.isTrue((boolean)StringTool.notNullNorEmpty((String)tableName));
            this.tableName = Optional.of(tableName);
        }
    }
}

