/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DatarouterAccountCounters;
import io.datarouter.auth.service.DatarouterAccountCredentialService;
import io.datarouter.auth.storage.accountpermission.DatarouterAccountPermissionKey;
import io.datarouter.util.tuple.Pair;
import io.datarouter.web.dispatcher.ApiKeyPredicate;
import io.datarouter.web.dispatcher.DispatchRule;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;

@Singleton
public class DatarouterAccountApiKeyPredicate
extends ApiKeyPredicate {
    private final DatarouterAccountCredentialService datarouterAccountCredentialService;
    private final DatarouterAccountCounters datarouterAccountCounters;

    @Inject
    public DatarouterAccountApiKeyPredicate(DatarouterAccountCredentialService datarouterAccountApiKeyService, DatarouterAccountCounters datarouterAccountCounters) {
        this("apiKey", datarouterAccountApiKeyService, datarouterAccountCounters);
    }

    private DatarouterAccountApiKeyPredicate(String apiKeyFieldName, DatarouterAccountCredentialService datarouterAccountCredentialService, DatarouterAccountCounters datarouterAccountCounters) {
        super(apiKeyFieldName);
        this.datarouterAccountCredentialService = datarouterAccountCredentialService;
        this.datarouterAccountCounters = datarouterAccountCounters;
    }

    public Pair<Boolean, String> innerCheck(DispatchRule rule, HttpServletRequest request, String apiKeyCandidate) {
        Optional endpoint = rule.getPersistentString();
        return this.check(endpoint, apiKeyCandidate).map(accountName -> new Pair((Object)true, accountName)).orElseGet(() -> new Pair((Object)false, (Object)("no account for " + DatarouterAccountApiKeyPredicate.obfuscate((String)apiKeyCandidate))));
    }

    public Optional<String> check(Optional<String> endpoint, String apiKeyCandidate) {
        Optional permission = this.datarouterAccountCredentialService.scanPermissionsForApiKeyAuth(apiKeyCandidate).include(candidate -> this.isValidEndpoint((DatarouterAccountPermissionKey)((Object)candidate), endpoint)).findFirst();
        permission.ifPresent(this.datarouterAccountCounters::incPermissionUsage);
        return permission.map(DatarouterAccountPermissionKey::getAccountName);
    }

    private boolean isValidEndpoint(DatarouterAccountPermissionKey candidate, Optional<String> endpoint) {
        boolean isWildcard = candidate.getEndpoint().equals("all");
        boolean matches = endpoint.map(candidate.getEndpoint()::equals).orElse(false);
        return isWildcard || matches;
    }

    @Singleton
    public static class DatarouterAccountApiKeyPredicateFactory {
        @Inject
        private DatarouterAccountCredentialService datarouterAccountCredentialService;
        @Inject
        private DatarouterAccountCounters datarouterAccountCounters;

        public DatarouterAccountApiKeyPredicate create(String apiKeyFieldName) {
            return new DatarouterAccountApiKeyPredicate(apiKeyFieldName, this.datarouterAccountCredentialService, this.datarouterAccountCounters);
        }
    }
}

