/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.web.deprovisioning;

import io.datarouter.auth.config.DatarouterAuthFiles;
import io.datarouter.auth.config.DatarouterAuthPaths;
import io.datarouter.auth.service.deprovisioning.UserDeprovisioningService;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUser;
import io.datarouter.auth.storage.deprovisioneduser.DeprovisionedUserDao;
import io.datarouter.auth.web.deprovisioning.DeprovisionedUserDto;
import io.datarouter.scanner.Scanner;
import io.datarouter.web.handler.BaseHandler;
import io.datarouter.web.handler.mav.Mav;
import io.datarouter.web.handler.types.RequestBody;
import io.datarouter.web.html.react.bootstrap4.Bootstrap4ReactPageFactory;
import io.datarouter.web.user.session.service.Session;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class UserDeprovisioningHandler
extends BaseHandler {
    private static final int DB_BATCH_SIZE = 1000;
    @Inject
    private Bootstrap4ReactPageFactory reactPageFactory;
    @Inject
    private DatarouterAuthFiles files;
    @Inject
    private DatarouterAuthPaths paths;
    @Inject
    private DeprovisionedUserDao deprovisionedUserDao;
    @Inject
    private UserDeprovisioningService userDeprovisioningService;

    @BaseHandler.Handler(defaultHandler=true)
    private Mav deprovisionedUsers() {
        return this.reactPageFactory.startBuilder(this.request).withTitle("Datarouter - User Deprovisioning").withReactScript(this.files.js.deprovisionedUsersJsx).withJsStringConstant("PATH", String.valueOf(this.request.getContextPath()) + this.paths.userDeprovisioning.toSlashedString()).buildMav();
    }

    @BaseHandler.Handler
    protected UserDeprovisioningHandlerGeneralDto fetchDeprovisionedUsers() {
        return (UserDeprovisioningHandlerGeneralDto)this.deprovisionedUserDao.scan().map(DeprovisionedUser::toDto).sort(DeprovisionedUserDto.COMPARATOR).listTo(UserDeprovisioningHandlerGeneralDto::fetchDeprovisionedUsers);
    }

    @BaseHandler.Handler
    protected UserDeprovisioningHandlerGeneralDto deprovisionUsers(@RequestBody UserDeprovisioningHandlerGeneralDto request) {
        Optional<String> currentUsername = this.getSessionInfo().getSession().map(Session::getUsername);
        return (UserDeprovisioningHandlerGeneralDto)Scanner.of((Iterable)Objects.requireNonNull(request.usernamesToDeprovision)).batch(1000).map(usernames -> this.userDeprovisioningService.deprovisionUsers((List<String>)usernames, currentUsername)).concat(Scanner::of).listTo(UserDeprovisioningHandlerGeneralDto::deprovisionUsersResponse);
    }

    @BaseHandler.Handler
    protected UserDeprovisioningHandlerGeneralDto restoreUsers(@RequestBody UserDeprovisioningHandlerGeneralDto request) {
        Optional<String> currentUsername = this.getSessionInfo().getSession().map(Session::getUsername);
        return (UserDeprovisioningHandlerGeneralDto)Scanner.of((Iterable)Objects.requireNonNull(request.usernamesToRestore)).batch(1000).map(usernames -> this.userDeprovisioningService.restoreUsers((List<String>)usernames, currentUsername)).concat(Scanner::of).listTo(UserDeprovisioningHandlerGeneralDto::restoreUsersResponse);
    }

    public static class UserDeprovisioningHandlerGeneralDto {
        public final List<String> usernamesToDeprovision;
        public final List<String> deprovisionedUsernames;
        public final List<String> usernamesToRestore;
        public final List<String> restoredUsernames;
        public final List<DeprovisionedUserDto> deprovisionedUsers;

        private UserDeprovisioningHandlerGeneralDto(List<String> usernamesToDeprovision, List<String> deprovisionedUsernames, List<String> usernamesToRestore, List<String> restoredUsernames, List<DeprovisionedUserDto> deprovisionedUsers) {
            this.usernamesToDeprovision = usernamesToDeprovision;
            this.deprovisionedUsernames = deprovisionedUsernames;
            this.usernamesToRestore = usernamesToRestore;
            this.restoredUsernames = restoredUsernames;
            this.deprovisionedUsers = deprovisionedUsers;
        }

        public static UserDeprovisioningHandlerGeneralDto deprovisionUsersResponse(List<String> deprovisionedUsernames) {
            return new UserDeprovisioningHandlerGeneralDto(null, deprovisionedUsernames, null, null, null);
        }

        public static UserDeprovisioningHandlerGeneralDto restoreUsersResponse(List<String> restoredUsernames) {
            return new UserDeprovisioningHandlerGeneralDto(null, null, null, restoredUsernames, null);
        }

        public static UserDeprovisioningHandlerGeneralDto fetchDeprovisionedUsers(List<DeprovisionedUserDto> deprovisionedUsers) {
            return new UserDeprovisioningHandlerGeneralDto(null, null, null, null, deprovisionedUsers);
        }
    }
}

