/*
 * Decompiled with CFR 0.152.
 */
package io.datarouter.auth.service;

import io.datarouter.auth.service.DefaultDatarouterAccountKeysSupplier;
import io.datarouter.auth.storage.account.BaseDatarouterAccountCredentialDao;
import io.datarouter.auth.storage.account.DatarouterAccountCredential;
import io.datarouter.auth.storage.account.DatarouterAccountCredentialKey;
import io.datarouter.auth.storage.user.DatarouterUserDao;
import io.datarouter.util.string.StringTool;
import io.datarouter.web.autoconfig.ConfigScanDto;
import io.datarouter.web.autoconfig.ConfigScanResponseTool;
import io.datarouter.web.user.databean.DatarouterUser;
import io.datarouter.web.user.databean.DatarouterUserKey;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DatarouterAuthConfigScanner {
    @Inject
    private BaseDatarouterAccountCredentialDao datarouterAccountCredentialDao;
    @Inject
    private DatarouterUserDao datarouterUserDao;
    @Inject
    private DefaultDatarouterAccountKeysSupplier defaultDatarouterAccountKeys;

    public ConfigScanDto checkDatarouterAccountsWithDefaultKeys() {
        List accounts = this.datarouterAccountCredentialDao.scan().include(credential -> StringTool.equalsCaseInsensitive((String)((DatarouterAccountCredentialKey)credential.getKey()).getApiKey(), (String)this.defaultDatarouterAccountKeys.getDefaultApiKey()) || StringTool.equalsCaseInsensitive((String)credential.getSecretKey(), (String)this.defaultDatarouterAccountKeys.getDefaultSecretKey())).map(DatarouterAccountCredential::getAccountName).list();
        if (accounts.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String header = "Found " + accounts.size() + " account credential(s) with the default apiKey or secretKey";
        return ConfigScanResponseTool.buildResponse((String)header, (Collection)accounts);
    }

    public ConfigScanDto checkForDefaultUserId() {
        Long defaultAdminId = 1L;
        Optional<DatarouterUser> defaultUser = this.datarouterUserDao.find(new DatarouterUserKey(defaultAdminId));
        if (defaultUser.isEmpty()) {
            return ConfigScanResponseTool.buildEmptyResponse();
        }
        String userName = defaultUser.get().getUsername();
        return ConfigScanResponseTool.buildResponse((String)("Found a user with the default admin id=" + defaultAdminId + " and username=" + userName));
    }
}

