/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.junit;

import cucumber.runtime.CucumberException;
import cucumber.runtime.Runtime;
import cucumber.runtime.junit.JUnitReporter;
import cucumber.runtime.junit.PickleRunners;
import cucumber.runtime.model.CucumberFeature;
import gherkin.ast.Feature;
import gherkin.events.PickleEvent;
import gherkin.pickles.Compiler;
import gherkin.pickles.Pickle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;

public class FeatureRunner
extends ParentRunner<PickleRunners.PickleRunner> {
    private final List<PickleRunners.PickleRunner> children = new ArrayList<PickleRunners.PickleRunner>();
    private final CucumberFeature cucumberFeature;
    private Description description;

    public FeatureRunner(CucumberFeature cucumberFeature, Runtime runtime, JUnitReporter jUnitReporter) throws InitializationError {
        super(null);
        this.cucumberFeature = cucumberFeature;
        this.buildFeatureElementRunners(runtime, jUnitReporter);
    }

    public String getName() {
        Feature feature = this.cucumberFeature.getGherkinFeature().getFeature();
        return feature.getKeyword() + ": " + feature.getName();
    }

    public Description getDescription() {
        if (this.description == null) {
            this.description = Description.createSuiteDescription((String)this.getName(), (Serializable)new FeatureId(this.cucumberFeature), (Annotation[])new Annotation[0]);
            for (PickleRunners.PickleRunner child : this.getChildren()) {
                this.description.addChild(this.describeChild(child));
            }
        }
        return this.description;
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    protected List<PickleRunners.PickleRunner> getChildren() {
        return this.children;
    }

    protected Description describeChild(PickleRunners.PickleRunner child) {
        return child.getDescription();
    }

    protected void runChild(PickleRunners.PickleRunner child, RunNotifier notifier) {
        child.run(notifier);
    }

    public void run(RunNotifier notifier) {
        super.run(notifier);
    }

    private void buildFeatureElementRunners(Runtime runtime, JUnitReporter jUnitReporter) {
        Feature feature = this.cucumberFeature.getGherkinFeature().getFeature();
        if (feature == null) {
            return;
        }
        Compiler compiler = new Compiler();
        ArrayList<PickleEvent> pickleEvents = new ArrayList<PickleEvent>();
        for (Pickle pickle : compiler.compile(this.cucumberFeature.getGherkinFeature())) {
            pickleEvents.add(new PickleEvent(this.cucumberFeature.getUri(), pickle));
        }
        for (PickleEvent pickleEvent : pickleEvents) {
            if (!runtime.matchesFilters(pickleEvent)) continue;
            try {
                PickleRunners.PickleRunner picklePickleRunner;
                if (jUnitReporter.stepNotifications()) {
                    picklePickleRunner = PickleRunners.withStepDescriptions(runtime.getRunner(), pickleEvent, jUnitReporter);
                    this.children.add(picklePickleRunner);
                    continue;
                }
                picklePickleRunner = PickleRunners.withNoStepDescriptions(feature.getName(), runtime.getRunner(), pickleEvent, jUnitReporter);
                this.children.add(picklePickleRunner);
            }
            catch (InitializationError e) {
                throw new CucumberException("Failed to create scenario runner", (Throwable)e);
            }
        }
    }

    private static final class FeatureId
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uri;

        FeatureId(CucumberFeature feature) {
            this.uri = feature.getUri();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureId featureId = (FeatureId)o;
            return this.uri.equals(featureId.uri);
        }

        public int hashCode() {
            return this.uri.hashCode();
        }

        public String toString() {
            return this.uri;
        }
    }
}

