/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Argument;
import io.cucumber.cucumberexpressions.ArgumentBuilder;
import io.cucumber.cucumberexpressions.ClassParameterType;
import io.cucumber.cucumberexpressions.ConstructorParameterType;
import io.cucumber.cucumberexpressions.Expression;
import io.cucumber.cucumberexpressions.ParameterType;
import io.cucumber.cucumberexpressions.ParameterTypeRegistry;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegularExpression
implements Expression {
    private static final Pattern CAPTURE_GROUP_PATTERN = Pattern.compile("\\(([^(]+)\\)");
    private final Pattern pattern;
    private final List<ParameterType<?>> parameterTypes;

    public RegularExpression(Pattern pattern, List<? extends Type> types, ParameterTypeRegistry parameterTypeRegistry) {
        this.pattern = pattern;
        this.parameterTypes = new ArrayList();
        Matcher matcher = CAPTURE_GROUP_PATTERN.matcher(pattern.pattern());
        int typeIndex = 0;
        while (matcher.find()) {
            Type type = types.size() <= typeIndex ? null : types.get(typeIndex++);
            String captureGroupPattern = matcher.group(1);
            ParameterType parameterType = null;
            if (type != null) {
                parameterType = parameterTypeRegistry.lookupByType(type);
            }
            if (parameterType == null) {
                parameterType = parameterTypeRegistry.lookupByRegexp(captureGroupPattern);
            }
            if (parameterType == null && type != null && type instanceof Class) {
                parameterType = new ClassParameterType((Class)type);
            }
            if (parameterType == null) {
                parameterType = new ConstructorParameterType<String>(String.class);
            }
            this.parameterTypes.add(parameterType);
        }
    }

    @Override
    public List<Argument> match(String text) {
        return ArgumentBuilder.buildArguments(this.pattern, text, this.parameterTypes);
    }

    @Override
    public String getSource() {
        return this.pattern.pattern();
    }
}

