/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.protobuf.ByteString;
import cronapi.odata.server.ODataAgent;
import cronapp.framework.customization.CloseODataAgentRequest;
import cronapp.framework.customization.CloseODataAgentResponse;
import cronapp.framework.customization.CustomizationServiceGrpc;
import cronapp.framework.customization.CustomizationSession;
import cronapp.framework.customization.EntityClassToJsonObjectConverter;
import cronapp.framework.customization.ExecuteODataAgentCommandRequest;
import cronapp.framework.customization.ExecuteODataAgentCommandResponse;
import cronapp.framework.customization.GetSessionRequest;
import cronapp.framework.customization.GetSessionResponse;
import cronapp.framework.customization.GetWebContentRequest;
import cronapp.framework.customization.GetWebContentResponse;
import cronapp.framework.customization.ListEntitiesRequest;
import cronapp.framework.customization.ListEntitiesResponse;
import cronapp.framework.customization.OpenODataAgentRequest;
import cronapp.framework.customization.OpenODataAgentResponse;
import io.grpc.stub.StreamObserver;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.persistence.Entity;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.jpa.Archive;

class CustomizationBindableService
extends CustomizationServiceGrpc.CustomizationServiceImplBase {
    private static final int START_RESULT = 28;
    private static final int END_RESULT = 29;
    private static final int READ_PAUSED = -1;
    private static final int READ_FINDING = 0;
    private static final int READ_READING = 1;
    private static final int READ_END = 2;
    private static final Map<Path, Path> mappedPaths = Map.of(Paths.get("META-INF", "app.config"), Paths.get("config", "app.config"), Paths.get("WEB-INF", "classes", "META-INF", "diagram"), Paths.get("diagram", new String[0]), Paths.get("WEB-INF", "classes", "META-INF", "customQuery.json"), Paths.get("src", "main", "java", "META-INF", "customQuery.json"), Paths.get("WEB-INF", "classes", "META-INF", "persistence.xml"), Paths.get("src", "main", "java", "META-INF", "persistence.xml"));
    private static final Set<Path> ignoredPaths = Set.of(Paths.get("WEB-INF", new String[0]));
    private final Logger logger = Logger.getLogger(CustomizationBindableService.class.getName());
    private final CustomizationSession customizationSession;
    private final ServletContext servletContext;
    private final EntityClassToJsonObjectConverter entityClassToJsonObjectConverter;
    private BufferedWriter outputWriter;
    private Process shell;
    private int resultType = -1;
    private OutputStream outputStream;
    private Function<Archive, List<String>> mapEntries = archive -> {
        Iterator entries = archive.getEntries();
        Iterable iterable = () -> entries;
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    };

    CustomizationBindableService(CustomizationSession customizationSession, ServletContext servletContext, EntityClassToJsonObjectConverter entityClassToJsonObjectConverter) {
        this.customizationSession = customizationSession;
        this.servletContext = servletContext;
        this.entityClassToJsonObjectConverter = entityClassToJsonObjectConverter;
    }

    @Override
    public void getSession(GetSessionRequest request, StreamObserver<GetSessionResponse> response) {
        response.onNext((Object)GetSessionResponse.newBuilder().setInstanceId(this.customizationSession.getInstanceId()).setInstanceVersion(this.customizationSession.getInstanceVersion()).setResourceName(this.customizationSession.getResourceName()).setResourceType(this.customizationSession.getResourceType().toLowerCase()).build());
        response.onCompleted();
    }

    @Override
    public void getWebContent(GetWebContentRequest request, StreamObserver<GetWebContentResponse> response) {
        Path zipEntryRootPath = Paths.get("src", "main", "webapp");
        Path servletContextPath = Paths.get(this.servletContext.getRealPath(""), new String[0]);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (ZipOutputStream zipOutputStream = new ZipOutputStream(buffer);
             Stream<Path> walker = Files.walk(servletContextPath, new FileVisitOption[0]);){
            walker.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                Path zipEntryRelativePath = servletContextPath.relativize((Path)path);
                Path zipEntryPath = CustomizationBindableService.resolve(zipEntryRelativePath, zipEntryRootPath);
                if (zipEntryPath == null) {
                    this.logger.info(String.format("Ignoring %s", zipEntryRelativePath));
                    return;
                }
                this.logger.info(String.format("Resolving %s to %s", zipEntryRelativePath, zipEntryPath));
                ZipEntry zipEntry = new ZipEntry(zipEntryPath.toString());
                try {
                    zipOutputStream.putNextEntry(zipEntry);
                    Files.copy(path, zipOutputStream);
                    zipOutputStream.closeEntry();
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, "Error putting next zip entry", e);
                }
            });
        }
        catch (IOException e) {
            response.onError((Throwable)e);
            return;
        }
        response.onNext((Object)GetWebContentResponse.newBuilder().setContent(ByteString.copyFrom((byte[])buffer.toByteArray())).build());
        response.onCompleted();
    }

    @Override
    public void openODataAgent(OpenODataAgentRequest request, StreamObserver<OpenODataAgentResponse> response) {
        try {
            if (this.shell == null || !this.shell.isAlive()) {
                String home = SystemUtils.getUserHome().toURI().getPath();
                String context = this.servletContext.getRealPath(Paths.get("META-INF", "context.xml").toString());
                String customQuery = this.servletContext.getRealPath(Paths.get("WEB-INF", "classes", "META-INF", "customQuery.json").toString());
                String libResources = this.classpath();
                LinkedList<String> commands = new LinkedList<String>();
                commands.add("/usr/lib/jvm/java-11-openjdk-amd64/bin/java");
                commands.add("-XX:MaxRAMPercentage=" + CustomizationBindableService.getPercentODataMemory());
                commands.add("-XX:+UseContainerSupport");
                commands.add("-Duser.dir=" + home);
                commands.add("-Duser.home=" + home);
                commands.add("-cp");
                commands.add(libResources);
                commands.add(ODataAgent.class.getName());
                commands.add(Paths.get(context, new String[0]).toUri().getPath());
                commands.add(Paths.get(customQuery, new String[0]).toUri().getPath());
                commands.add(request.getActiveProfile());
                ProcessBuilder processBuilder = new ProcessBuilder(commands);
                processBuilder.environment().remove("JAVA_OPTS");
                this.shell = processBuilder.start();
                BufferedReader inputReader = new BufferedReader(new InputStreamReader(this.shell.getInputStream(), StandardCharsets.UTF_8));
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(this.shell.getErrorStream(), StandardCharsets.UTF_8));
                this.outputWriter = new BufferedWriter(new OutputStreamWriter(this.shell.getOutputStream(), StandardCharsets.UTF_8));
                new Thread(() -> this.printReader(inputReader)).start();
                new Thread(() -> this.printReader(errorReader)).start();
            }
            response.onNext((Object)OpenODataAgentResponse.newBuilder().build());
            response.onCompleted();
        }
        catch (Exception e) {
            response.onError((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeODataAgentCommand(ExecuteODataAgentCommandRequest request, StreamObserver<ExecuteODataAgentCommandResponse> response) {
        this.resultType = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.outputStream = out;
        try {
            boolean wasRunning;
            boolean bl = wasRunning = this.shell != null && this.shell.isAlive();
            if (!wasRunning) {
                Thread.sleep(1000L);
            }
            this.outputWriter.write(request.getODataAgentCommand());
            this.outputWriter.flush();
            while (this.resultType != 2 && this.shell != null && this.shell.isAlive()) {
                Thread.sleep(100L);
            }
            ByteString outputData = ByteString.copyFrom((byte[])out.toByteArray());
            response.onNext((Object)ExecuteODataAgentCommandResponse.newBuilder().setOutputData(outputData).build());
            response.onCompleted();
        }
        catch (IOException | InterruptedException e) {
            response.onError((Throwable)e);
        }
        finally {
            this.outputStream = null;
        }
    }

    @Override
    public void closeODataAgent(CloseODataAgentRequest request, StreamObserver<CloseODataAgentResponse> response) {
        if (this.shell != null && this.shell.isAlive()) {
            this.shell.destroy();
        }
        response.onNext((Object)CloseODataAgentResponse.newBuilder().build());
        response.onCompleted();
    }

    @Override
    public void listEntities(ListEntitiesRequest request, StreamObserver<ListEntitiesResponse> response) {
        try {
            JsonArray entitiesJson = new JsonArray();
            Set archives = PersistenceUnitProcessor.findPersistenceArchives();
            List candidates = archives.stream().map(this.mapEntries).flatMap(Collection::stream).filter(entry -> entry.endsWith(".class")).map(entry -> entry.replace("/", ".")).map(entry -> entry.substring(0, entry.indexOf(".class"))).collect(Collectors.toList());
            for (String candidate : candidates) {
                try {
                    Class<?> entityClass = Class.forName(candidate);
                    if (!entityClass.isAnnotationPresent(Entity.class)) continue;
                    JsonObject jsonObject = this.entityClassToJsonObjectConverter.convert(entityClass);
                    entitiesJson.add((JsonElement)jsonObject);
                }
                catch (ClassNotFoundException e) {
                    this.logger.log(Level.SEVERE, String.format("Error retrieving class %s", candidate), e);
                }
            }
            String entities = new Gson().toJson((JsonElement)entitiesJson);
            response.onNext((Object)ListEntitiesResponse.newBuilder().setEntities(entities).build());
            response.onCompleted();
        }
        catch (Exception e) {
            response.onError((Throwable)e);
        }
    }

    private static Path resolve(Path path, Path defaultRoot) {
        Path parentPath = path.getParent();
        if (mappedPaths.containsKey(path)) {
            return mappedPaths.get(path);
        }
        if (parentPath != null && mappedPaths.containsKey(parentPath)) {
            Path mappedParentPath = mappedPaths.get(parentPath);
            Path relativePath = parentPath.relativize(path);
            return mappedParentPath.resolve(relativePath);
        }
        if (ignoredPaths.stream().noneMatch(path::startsWith)) {
            return mappedPaths.containsKey(path) ? mappedPaths.get(path) : defaultRoot.resolve(path);
        }
        return null;
    }

    private void printReader(BufferedReader bufferedReader) {
        try {
            char[] data = new char[1];
            while (bufferedReader.read(data, 0, data.length) != -1) {
                if (this.resultType != 0 && this.resultType != 1) continue;
                if (this.resultType == 1) {
                    if (data[0] == '\u001d') {
                        this.resultType = 2;
                    } else {
                        this.outputStream.write(String.valueOf(data[0]).getBytes(StandardCharsets.UTF_8));
                    }
                }
                if (data[0] != '\u001c') continue;
                this.resultType = 1;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error printing reader", e);
        }
    }

    private String classpath() throws IOException {
        String classes = this.servletContext.getRealPath(Paths.get("WEB-INF", "classes").toString());
        Path libs = Paths.get(this.servletContext.getRealPath(Paths.get("WEB-INF", "lib").toString()), new String[0]);
        StringBuilder classpath = new StringBuilder(classes);
        try (Stream<Path> walker = Files.walk(libs, new FileVisitOption[0]);){
            walker.forEach(path -> classpath.append(":").append(path.toUri().getPath()));
        }
        return classpath.toString();
    }

    private static String getPercentODataMemory() {
        double percent = 10.0;
        DecimalFormat format = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ENGLISH));
        format.setGroupingUsed(false);
        return format.format(percent);
    }
}

