/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import cronapp.framework.core.CronappFrameworkException;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.JpaVendorAdapter;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.EclipseLinkJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@EnableJpaRepositories(basePackageClasses={ReportsConfiguration.class}, entityManagerFactoryRef="reportsEntityManagerFactory", transactionManagerRef="reportsTransactionManager")
public class ReportsConfiguration
implements InitializingBean {
    private static final String CHANGE_LOG_FILE = "customization-reports-db-changes.xml";
    private final DataSource dataSource;

    public ReportsConfiguration(@Qualifier(value="cronappDataSource") DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    public LocalContainerEntityManagerFactoryBean reportsEntityManagerFactory() {
        LocalContainerEntityManagerFactoryBean factoryBean = new LocalContainerEntityManagerFactoryBean();
        factoryBean.setDataSource(this.dataSource);
        factoryBean.setPackagesToScan(new String[]{this.getClass().getPackage().getName()});
        factoryBean.setJpaVendorAdapter((JpaVendorAdapter)new EclipseLinkJpaVendorAdapter());
        factoryBean.setJpaPropertyMap(Map.of("eclipselink.weaving", "false"));
        return factoryBean;
    }

    @Bean
    public PlatformTransactionManager reportsTransactionManager() {
        JpaTransactionManager transactionManager = new JpaTransactionManager();
        transactionManager.setEntityManagerFactory(this.reportsEntityManagerFactory().getObject());
        return transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        try {
            JdbcConnection connection = new JdbcConnection(this.dataSource.getConnection());
            Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)connection);
            Liquibase liquibase = new Liquibase(CHANGE_LOG_FILE, (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
            liquibase.update((String)null);
        }
        catch (SQLException | LiquibaseException e) {
            throw new CronappFrameworkException(e);
        }
    }
}

