/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.serializing.StiDeserializationException;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import cronapp.framework.customization.reports.Report;
import cronapp.framework.customization.reports.odata.StiODataDatabase;
import cronapp.framework.customization.reports.odata.StiODataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ReportToStiReportConverter
implements Converter<Report, StiReport> {
    @NonNull
    public StiReport convert(@NonNull Report report) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(report.getContent().getBytes(StandardCharsets.UTF_8));
            StiReport stiReport = StiSerializeManager.deserializeReportFromJson((InputStream)input);
            this.removeUnwantedProperties(stiReport);
            return stiReport;
        }
        catch (JSONException | StiDeserializationException | IOException | ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void removeUnwantedProperties(@NonNull StiReport stiReport) {
        stiReport.getReferencedAssemblies().clear();
        stiReport.setScript(null);
    }

    static {
        StiOptions.Services.getDataSource().add(StiODataSource.class);
        StiOptions.Services.getDataBases().add(StiODataDatabase.class);
    }
}

