/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.base.json.JSONObject;
import cronapp.framework.core.CronappFrameworkException;
import cronapp.framework.customization.reports.RenderedReportDto;
import cronapp.framework.customization.reports.Report;
import cronapp.framework.customization.reports.ReportNotFoundException;
import cronapp.framework.customization.reports.ReportService;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/customization/reports"})
public class ReportCustomizationController {
    private final ReportService service;

    @Autowired
    public ReportCustomizationController(ReportService service) {
        this.service = service;
    }

    @GetMapping
    public ResponseEntity<List<String>> findAll() {
        List reports = this.service.findAll().stream().map(Report::getName).map(FilenameUtils::getBaseName).collect(Collectors.toUnmodifiableList());
        return ResponseEntity.ok(reports);
    }

    @PostMapping
    public ResponseEntity<Report> create(@RequestBody Report report) {
        return ResponseEntity.ok((Object)this.service.save(report));
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Report> update(@PathVariable UUID id, @RequestBody Report report) {
        Report record = this.service.findById(id).orElseThrow(ReportNotFoundException::new);
        record.setName(report.getName());
        record.setContent(report.getContent());
        return ResponseEntity.ok((Object)this.service.save(record));
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity delete(@PathVariable UUID id) {
        this.service.deleteById(id);
        return ResponseEntity.ok().build();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Resource> get(@PathVariable(value="id") UUID id, @RequestHeader(value="Content-Type", defaultValue="application/json") String contentType) throws CronappFrameworkException {
        final RenderedReportDto renderedReport = this.service.render(id, contentType);
        ByteArrayResource resource = new ByteArrayResource(renderedReport.getBytes()){

            public String getFilename() {
                return renderedReport.getFileName();
            }
        };
        return ResponseEntity.ok().contentType(renderedReport.getMediaType()).body((Object)resource);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.OPTIONS})
    public JSONObject listVariables(@PathVariable(value="id") UUID id) throws CronappFrameworkException {
        try {
            return this.service.listVariables(id).SaveToJsonObjectEx(StiJsonSaveMode.Report);
        }
        catch (JSONException e) {
            throw new CronappFrameworkException((Throwable)e);
        }
    }
}

