/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import com.stimulsoft.base.StiJsonSaveMode;
import com.stimulsoft.base.json.JSONException;
import com.stimulsoft.report.StiReport;
import cronapp.framework.customization.reports.GetReportContentRequest;
import cronapp.framework.customization.reports.GetReportContentResponse;
import cronapp.framework.customization.reports.IsReportCustomizableRequest;
import cronapp.framework.customization.reports.IsReportCustomizableResponse;
import cronapp.framework.customization.reports.Report;
import cronapp.framework.customization.reports.ReportCustomizationServiceGrpc;
import cronapp.framework.customization.reports.ReportService;
import cronapp.framework.customization.reports.SaveReportContentRequest;
import cronapp.framework.customization.reports.SaveReportContentResponse;
import io.grpc.stub.StreamObserver;
import org.springframework.lang.NonNull;

class ReportCustomizationBindableService
extends ReportCustomizationServiceGrpc.ReportCustomizationServiceImplBase {
    private final ReportService reportService;

    ReportCustomizationBindableService(@NonNull ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public void isCustomizable(IsReportCustomizableRequest request, StreamObserver<IsReportCustomizableResponse> responseObserver) {
        responseObserver.onNext((Object)IsReportCustomizableResponse.newBuilder().setIsCustomizable(true).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getContent(GetReportContentRequest request, StreamObserver<GetReportContentResponse> responseObserver) {
        try {
            Report report = this.reportService.findByName(request.getReportName()).orElse(new Report());
            responseObserver.onNext((Object)GetReportContentResponse.newBuilder().setContent(this.getContentFromReport(report)).build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    @Override
    public void saveContent(SaveReportContentRequest request, StreamObserver<SaveReportContentResponse> responseObserver) {
        try {
            Report report = this.reportService.findByName(request.getReportName()).orElse(new Report());
            report.setName(request.getReportName());
            report.setContent(request.getContent());
            this.reportService.save(report);
            responseObserver.onNext((Object)SaveReportContentResponse.newBuilder().build());
            responseObserver.onCompleted();
        }
        catch (Exception e) {
            responseObserver.onError((Throwable)e);
        }
    }

    private String getContentFromReport(@NonNull Report report) throws JSONException {
        if (report.getId() == null) {
            return StiReport.newInstance().saveToJsonInternal(StiJsonSaveMode.Report);
        }
        return report.getContent();
    }
}

