/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.customization.reports;

import com.stimulsoft.report.enums.StiExportFormat;
import cronapp.framework.customization.reports.ContentTypeNotSupportedException;
import java.util.HashMap;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class ContentTypeToExportFormatConverter
implements Converter<String, ExportFormatWrapper> {
    static final String APPLICATION_EXCEL_VALUE = "application/vnd.ms-excel";
    static final String APPLICATION_RTF_VALUE = "application/rtf";
    static final String TEXT_CSV_VALUE = "text/csv";
    private static HashMap<String, StiExportFormat> mappings = new HashMap();

    @NonNull
    public ExportFormatWrapper convert(@NonNull String contentType) {
        for (String type : contentType.split(",")) {
            if (!mappings.containsKey(type)) continue;
            return new ExportFormatWrapper(mappings.get(type), type);
        }
        throw new ContentTypeNotSupportedException();
    }

    static {
        mappings.put("application/pdf", StiExportFormat.Pdf);
        mappings.put("text/html", StiExportFormat.Html);
        mappings.put("text/plain", StiExportFormat.Text);
        mappings.put("image/jpeg", StiExportFormat.ImageJpeg);
        mappings.put("image/png", StiExportFormat.ImagePng);
        mappings.put("application/xml", StiExportFormat.Xml);
        mappings.put(APPLICATION_EXCEL_VALUE, StiExportFormat.Excel);
        mappings.put(APPLICATION_RTF_VALUE, StiExportFormat.Rtf);
        mappings.put(TEXT_CSV_VALUE, StiExportFormat.Csv);
    }

    class ExportFormatWrapper {
        private StiExportFormat exportFormat;
        private String mediaType;

        private ExportFormatWrapper(StiExportFormat exportFormat, String mediaType) {
            this.exportFormat = exportFormat;
            this.mediaType = mediaType;
        }

        StiExportFormat getExportFormat() {
            return this.exportFormat;
        }

        String getMediaType() {
            return this.mediaType;
        }
    }
}

