/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core.model;

import cronapp.framework.core.CronappConfiguration;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.model.SecureValue;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.mappings.transformers.AttributeTransformerAdapter;
import org.eclipse.persistence.mappings.transformers.FieldTransformerAdapter;
import org.eclipse.persistence.sessions.DataRecord;
import org.eclipse.persistence.sessions.Session;
import org.springframework.security.crypto.encrypt.Encryptors;

@Entity
@Table(name="CRONAPP_SETTINGS")
public class CronappSettings {
    private static final String FIELD_VALUE = "VALUE";
    private static final String FIELD_SECURE = "SECURE";
    @Id
    @Column(name="ID")
    private String id;
    @Column(name="APPLICATION_ID")
    private String applicationId;
    @Column(name="NAME")
    private String name;
    @ReadTransformer(transformerClass=Reader.class)
    @WriteTransformers(value={@WriteTransformer(column=@Column(name="SECURE"), transformerClass=Writer.class), @WriteTransformer(column=@Column(name="VALUE"), transformerClass=Writer.class)})
    private SecureValue secureValue = new SecureValue();

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.secureValue.getValue();
    }

    public void setValue(String value) {
        this.secureValue.setValue(value);
    }

    public Boolean getSecure() {
        return this.secureValue.getSecure();
    }

    public void setSecure(Boolean secure) {
        this.secureValue.setSecure(secure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CronappSettings settings = (CronappSettings)o;
        return new EqualsBuilder().append((Object)this.id, (Object)settings.id).append((Object)this.applicationId, (Object)settings.applicationId).append((Object)this.name, (Object)settings.name).append((Object)this.secureValue, (Object)settings.secureValue).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.applicationId).append((Object)this.name).append((Object)this.secureValue).toHashCode();
    }

    public static final class Builder {
        private String id;
        private String applicationId;
        private String name;
        private Boolean secure;
        private String value;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setApplicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setSecure(Boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder setValue(String value) {
            this.value = value;
            return this;
        }

        public CronappSettings build() {
            CronappSettings cronappSettings = new CronappSettings();
            cronappSettings.setId(this.id);
            cronappSettings.setApplicationId(this.applicationId);
            cronappSettings.setName(this.name);
            cronappSettings.secureValue.setSecure(this.secure);
            cronappSettings.secureValue.setValue(this.value);
            return cronappSettings;
        }
    }

    public static final class Reader
    extends AttributeTransformerAdapter {
        public Object buildAttributeValue(DataRecord record, Object object, Session session) {
            String value;
            boolean secure = BooleanUtils.toBoolean((String)ObjectUtils.firstNonNull((Object[])new Object[]{record.get((Object)CronappSettings.FIELD_SECURE), false}).toString());
            Object rawValue = record.get((Object)CronappSettings.FIELD_VALUE);
            if (rawValue == null) {
                value = null;
            } else if (secure) {
                CronappSettingsService settingsService = CronappConfiguration.getBean(CronappSettingsService.class);
                value = Encryptors.text((CharSequence)settingsService.getEncryptionKey(), (CharSequence)settingsService.getEncryptionSalt()).decrypt(rawValue.toString());
            } else {
                value = rawValue.toString();
            }
            return SecureValue.newBuilder().setSecure(secure).setValue(value).build();
        }
    }

    public static final class Writer
    extends FieldTransformerAdapter {
        public Object buildFieldValue(Object object, String fieldName, Session session) {
            CronappSettings settings = (CronappSettings)object;
            Boolean secure = settings.getSecure();
            String value = settings.getValue();
            switch (fieldName) {
                case "VALUE": {
                    CronappSettingsService settingsService = CronappConfiguration.getBean(CronappSettingsService.class);
                    return BooleanUtils.isTrue((Boolean)secure) && StringUtils.isNotEmpty((CharSequence)value) ? Encryptors.text((CharSequence)settingsService.getEncryptionKey(), (CharSequence)settingsService.getEncryptionSalt()).encrypt(value) : value;
                }
                case "SECURE": {
                    return BooleanUtils.isTrue((Boolean)secure);
                }
            }
            return super.buildFieldValue(object, fieldName, session);
        }
    }
}

