/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.AppConfigUtil;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.model.AppConfiguration;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.core.env.Environment;

@CacheConfig(cacheNames={"cronapp.framework.core.settings"})
public class PropertiesSettingsService
implements CronappSettingsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Environment environment;

    public PropertiesSettingsService(Environment environment) {
        this.environment = environment;
    }

    @Override
    public String getOption(String option) {
        return this.environment.getProperty(option);
    }

    @Override
    public void addOption(String option, boolean secure) {
        this.logger.warn("PropertiesSettingsService.addOption is not implemented");
    }

    @Override
    public String getEncryptionKey() {
        return DigestUtils.sha1Hex((String)AppConfiguration.getInstance().getSecurity().getToken());
    }

    @Override
    public String getEncryptionSalt() {
        return DigestUtils.sha1Hex((String)this.getApplicationId());
    }

    @Override
    public String getApplicationId() {
        return AppConfiguration.getInstance().getApp().getGuid();
    }

    @Override
    public String getIntanceId() {
        return AppConfigUtil.getIntanceId();
    }
}

