/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.FieldError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice
public class CronappExceptionHandler
extends ResponseEntityExceptionHandler {
    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatusCode status, WebRequest request) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (FieldError error : ex.getBindingResult().getFieldErrors()) {
            errors.add((CallSite)((Object)(error.getField() + ": " + error.getDefaultMessage())));
        }
        for (FieldError error : ex.getBindingResult().getGlobalErrors()) {
            errors.add((CallSite)((Object)(error.getObjectName() + ": " + error.getDefaultMessage())));
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("timestamp", new Date());
        body.put("status", status.value());
        body.put("message", String.join((CharSequence)"\n", errors));
        if (status instanceof HttpStatus) {
            HttpStatus httpStatus = (HttpStatus)status;
            body.put("error", httpStatus.getReasonPhrase());
        }
        if (request instanceof ServletWebRequest) {
            ServletWebRequest servletWebRequest = (ServletWebRequest)request;
            body.put("path", servletWebRequest.getRequest().getRequestURI());
        }
        return this.handleExceptionInternal((Exception)ex, body, headers, status, request);
    }
}

