/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappDatabaseConfiguration;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Order(value=0x7FFFFFFE)
public class CoreEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final String CONFIG_RESOURCE_LOCATION = "classpath:/config/cronapp";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        block13: {
            Map properties = environment.getSystemProperties();
            properties.put("server.error.includeMessage", "ALWAYS");
            properties.put("server.forward-headers-strategy", "framework");
            if (environment.getProperty("logging.level.org.reflections") == null) {
                properties.put("logging.level.org.reflections", "WARN");
            }
            if (environment.getProperty("spring.liquibase.enabled") == null) {
                properties.put("spring.liquibase.enabled", false);
            }
            if (environment.getProperty("cronapp.datasource.url") == null && CronappDatabaseConfiguration.getCronappDataSourceName().isEmpty()) {
                properties.put("cronapp.data.enabled", false);
                properties.put("cronapp.liquibase.enabled", false);
                properties.put("management.health.db", false);
            } else {
                properties.put("cronapp.data.enabled", true);
            }
            try {
                PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
                if (!resourceResolver.getResource(CONFIG_RESOURCE_LOCATION).exists()) break block13;
                Resource[] configResources = resourceResolver.getResources("classpath:/config/cronapp/*.properties");
                for (int i = 0; i < configResources.length; ++i) {
                    Properties configProperties = new Properties();
                    Resource configResource = configResources[i];
                    try (InputStream configStream = configResource.getInputStream();){
                        configProperties.load(configStream);
                    }
                    environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("cronapp-" + i, configProperties));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

