/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.AppConfigUtil;
import cronapp.framework.core.CronappSettingsRepository;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.model.AppConfiguration;
import cronapp.framework.core.model.CronappSettings;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.env.Environment;

@DependsOn(value={"liquibase"})
@CacheConfig(cacheNames={"cronapp.framework.core.settings"})
public class RepositorySettingsService
implements CronappSettingsService {
    private final CronappSettingsRepository settingsRepository;
    private final Environment environment;

    public RepositorySettingsService(CronappSettingsRepository settingsRepository, Environment environment) {
        this.settingsRepository = settingsRepository;
        this.environment = environment;
    }

    @Override
    public String getOption(String option) {
        return this.settingsRepository.findByApplicationIdAndName(this.getApplicationId(), option).orElse(CronappSettings.newBuilder().build()).getValue();
    }

    @Override
    public void addOption(String option, boolean secure) {
        Optional<CronappSettings> settings = this.settingsRepository.findByApplicationIdAndName(this.getApplicationId(), option);
        if (settings.isPresent()) {
            String[] reloadProperties = (String[])this.environment.getProperty("reload.properties", String[].class);
            if (reloadProperties != null && Arrays.asList(reloadProperties).stream().anyMatch(item -> item.equals("all") || item.equals(option))) {
                CronappSettings item2 = settings.get();
                item2.setValue(this.environment.getProperty(option));
                this.settingsRepository.save(item2);
            }
            return;
        }
        this.settingsRepository.save(CronappSettings.newBuilder().setId(UUID.randomUUID().toString()).setApplicationId(this.getApplicationId()).setName(option).setSecure(secure).setValue(this.environment.getProperty(option)).build());
    }

    @Override
    public String getEncryptionKey() {
        return DigestUtils.sha1Hex((String)AppConfiguration.getInstance().getSecurity().getToken());
    }

    @Override
    public String getEncryptionSalt() {
        return DigestUtils.sha1Hex((String)this.getApplicationId());
    }

    @Override
    public String getIntanceId() {
        return AppConfigUtil.getIntanceId();
    }

    @Override
    public String getApplicationId() {
        return AppConfiguration.getInstance().getApp().getGuid();
    }
}

