/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import java.sql.DatabaseMetaData;
import javax.sql.DataSource;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;

public final class DatabaseSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DatabaseSupport.class);

    private DatabaseSupport() {
    }

    public static DatabaseDriver getDatabaseDriver(DataSource dataSource) {
        try {
            String databaseProductName = (String)JdbcUtils.extractDatabaseMetaData((DataSource)dataSource, DatabaseMetaData::getDatabaseProductName);
            String commonDatabaseName = JdbcUtils.commonDatabaseName((String)databaseProductName);
            return DatabaseDriver.fromProductName((String)commonDatabaseName);
        }
        catch (MetaDataAccessException e) {
            log.error("Error detecting driver delegate class", (Throwable)e);
            return DatabaseDriver.UNKNOWN;
        }
    }
}

