/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.liquibase.CronappChangeLog;
import cronapp.framework.core.liquibase.CronappLiquibase;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Configuration
@ConditionalOnProperty(value={"cronapp.data.enabled", "cronapp.liquibase.enabled"})
public class CronappLiquibaseConfiguration {
    @Bean
    public SpringLiquibase liquibase(List<CronappChangeLog> changeLogs, ResourceLoader resourceLoader, @Qualifier(value="cronappDataSource") DataSource dataSource) throws Exception {
        if (changeLogs.isEmpty()) {
            return null;
        }
        boolean hasChanges = false;
        CronappLiquibase liquibase = new CronappLiquibase();
        liquibase.setDataSource(dataSource);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        CronappChangeLog baseChangeLog = CronappChangeLog.newBuilder().setDataModel("classpath:empty-db-changes.xml").build();
        Resource baseResource = resourceLoader.getResource(baseChangeLog.getDataModel());
        try (InputStream baseResourceStream = baseResource.getInputStream();){
            Document baseDocument = documentBuilder.parse(baseResourceStream);
            Element baseDocumentElement = baseDocument.getDocumentElement();
            for (CronappChangeLog changeLog : changeLogs) {
                String dataModel = changeLog.getDataModel();
                if (dataModel == null) continue;
                hasChanges = true;
                Resource resource = resourceLoader.getResource(changeLog.getDataModel());
                InputStream resourceStream = resource.getInputStream();
                try {
                    Document document = documentBuilder.parse(resourceStream);
                    NodeList childNodes = document.getDocumentElement().getChildNodes();
                    IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).map(node -> baseDocument.importNode((Node)node, true)).forEach(baseDocumentElement::appendChild);
                }
                finally {
                    if (resourceStream == null) continue;
                    resourceStream.close();
                }
            }
            if (hasChanges) {
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(baseDocument);
                Path resultPath = Files.createTempFile("cronapp-database-changelog", ".xml", new FileAttribute[0]);
                FileWriter fileWriter = new FileWriter(resultPath.toFile());
                StreamResult result = new StreamResult(fileWriter);
                transformer.transform(source, result);
                liquibase.setChangeLog("application:cronapp-framework.xml");
                liquibase.setMergedChangelogPath(resultPath.toUri().toString());
                CronappLiquibase cronappLiquibase = liquibase;
                return cronappLiquibase;
            }
        }
        return null;
    }

    @Bean
    public CronappChangeLog coreLiquibaseChangelog(Environment environment) {
        return CronappChangeLog.newBuilder().setDataModel("classpath:core-db-changes.xml").build();
    }
}

