/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappSettingsRepository;
import cronapp.framework.core.CronappSettingsService;
import cronapp.framework.core.PropertiesSettingsService;
import cronapp.framework.core.RepositorySettingsService;
import java.util.Optional;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.lang.Nullable;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProvider;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.DefaultOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;

@Configuration
@ComponentScan
@EnableCaching
public class CronappConfiguration
implements ApplicationContextAware {
    public static final int PROPERTY_HANDLER_ORDER = Integer.MAX_VALUE;
    public static final String PROPERTY_FEATURE_DATABASE = "cronapp.data.enabled";
    public static final String PROPERTY_FEATURE_LIQUIBASE = "cronapp.liquibase.enabled";
    private static ApplicationContext applicationContext;

    public static boolean hasDatabase(Environment environment) {
        return environment.getProperty(PROPERTY_FEATURE_DATABASE, Boolean.class, (Object)Boolean.TRUE) == Boolean.TRUE;
    }

    public static boolean hasDatabase() {
        return CronappConfiguration.hasDatabase(applicationContext.getEnvironment());
    }

    public static String getProperty(String key) {
        return applicationContext.getEnvironment().getProperty(key);
    }

    public static <T> T getBean(String name, @Nullable Class<T> requiredType) {
        return (T)applicationContext.getBean(name, requiredType);
    }

    public static Object getBean(String name) {
        return applicationContext.getBean(name);
    }

    public static <T> T getBean(Class<T> requiredType) {
        return (T)applicationContext.getBean(requiredType);
    }

    public static <T> T autowire(Class<T> requiredType) {
        return (T)applicationContext.getAutowireCapableBeanFactory().autowire(requiredType, 3, true);
    }

    @Bean
    @ConditionalOnBean(value={CronappSettingsRepository.class})
    public CronappSettingsService repositorySettingsService(CronappSettingsRepository settingsRepository, Environment environment) {
        return new RepositorySettingsService(settingsRepository, environment);
    }

    @Bean
    @ConditionalOnMissingBean(value={CronappSettingsRepository.class})
    public CronappSettingsService propertiesSettingsService(Environment environment) {
        return new PropertiesSettingsService(environment);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        CronappConfiguration.applicationContext = applicationContext;
    }

    @Bean
    public CacheManager cacheManager() {
        return new ConcurrentMapCacheManager();
    }

    @Bean
    public OAuth2AuthorizedClientManager authorizedClientManager(Optional<ClientRegistrationRepository> clientRegistrationRepository, Optional<OAuth2AuthorizedClientRepository> authorizedClientRepository) {
        if (clientRegistrationRepository.isEmpty() || authorizedClientRepository.isEmpty()) {
            return null;
        }
        OAuth2AuthorizedClientProvider authorizedClientProvider = OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build();
        DefaultOAuth2AuthorizedClientManager authorizedClientManager = new DefaultOAuth2AuthorizedClientManager(clientRegistrationRepository.get(), authorizedClientRepository.get());
        authorizedClientManager.setAuthorizedClientProvider(authorizedClientProvider);
        return authorizedClientManager;
    }
}

