/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import cronapp.framework.core.CronappTokenProperties;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.stereotype.Component;

@Component
public class CronappTokenManager {
    private final Optional<OAuth2AuthorizedClientManager> authorizedClientManager;
    private final CronappTokenProperties tokenProperties;

    public CronappTokenManager(Optional<OAuth2AuthorizedClientManager> authorizedClientManager, CronappTokenProperties tokenProperties) {
        this.authorizedClientManager = authorizedClientManager;
        this.tokenProperties = tokenProperties;
    }

    public void addHeaders(String url, BiConsumer<String, String> action) {
        CronappTokenProperties.Registration registration = this.findRegistration(url);
        if (registration == null) {
            return;
        }
        if (registration.getType() == null) {
            return;
        }
        if (registration.getType().equals("OAUTH2")) {
            this.authorizedClientManager.ifPresent(authorizedClientManager -> {
                OAuth2AccessToken accessToken;
                OAuth2AuthorizeRequest authorizeRequest = OAuth2AuthorizeRequest.withClientRegistrationId((String)registration.getId()).principal(registration.getId()).build();
                OAuth2AuthorizedClient authorizedClient = authorizedClientManager.authorize(authorizeRequest);
                if (authorizedClient != null && (accessToken = authorizedClient.getAccessToken()) != null) {
                    action.accept("Authorization", "Bearer " + accessToken.getTokenValue());
                }
            });
        } else if (registration.getType().equals("API_KEY") && "HEADER".equals(registration.getApiKeyIn()) && registration.getApiKeyName() != null && registration.getApiKeyValue() != null) {
            action.accept(registration.getApiKeyName(), registration.getApiKeyValue());
        }
    }

    public void process(HttpRequestBase httpMethod) {
        this.addHeaders(httpMethod.getURI().toString(), (arg_0, arg_1) -> ((HttpRequestBase)httpMethod).addHeader(arg_0, arg_1));
    }

    private CronappTokenProperties.Registration findRegistration(String url) {
        return this.tokenProperties.getRegistration().values().stream().filter(r -> this.matchesUrlPredicate(url, (CronappTokenProperties.Registration)r)).findFirst().orElse(null);
    }

    private boolean matchesUrlPredicate(String url, CronappTokenProperties.Registration value) {
        if (url == null || value == null) {
            return false;
        }
        for (String resourceServerUrl : value.getResourceServerUrls()) {
            if (resourceServerUrl == null) continue;
            return url.startsWith(StringUtils.appendIfMissing((String)resourceServerUrl, (CharSequence)"/", (CharSequence[])new CharSequence[0])) || StringUtils.removeEnd((String)resourceServerUrl, (String)"/").equals(StringUtils.removeEnd((String)url, (String)"/"));
        }
        return false;
    }
}

