/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;

@Component(value="coreInvocationVoter")
public class FilterInvocationVoter
implements AccessDecisionVoter<FilterInvocation> {
    private final List<RequestMatcher> requestMatchers = new ArrayList<RequestMatcher>();

    public FilterInvocationVoter() {
        this.requestMatchers.add((RequestMatcher)new AntPathRequestMatcher("/"));
        this.requestMatchers.add((RequestMatcher)new AntPathRequestMatcher("/cronapp.json"));
        this.requestMatchers.add((RequestMatcher)new AntPathRequestMatcher("/node_modules/**"));
    }

    public boolean supports(ConfigAttribute configAttribute) {
        return true;
    }

    public boolean supports(Class<?> aClass) {
        return FilterInvocation.class.isAssignableFrom(aClass);
    }

    public int vote(Authentication authentication, FilterInvocation filterInvocation, Collection<ConfigAttribute> collection) {
        OrRequestMatcher matcher = new OrRequestMatcher(this.requestMatchers);
        if (matcher.matches(filterInvocation.getRequest())) {
            return 1;
        }
        return 0;
    }
}

